/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.container.StorageType;
import org.infinispan.eviction.EvictionType;

public class MemoryConfiguration {
    public static final AttributeDefinition<Integer> ADDRESS_COUNT = AttributeDefinition.builder("address-count", 0x100000).build();
    public static final AttributeDefinition<StorageType> STORAGE_TYPE = AttributeDefinition.builder("storage", StorageType.OBJECT).copier(IdentityAttributeCopier.INSTANCE).immutable().build();
    public static final AttributeDefinition<Long> SIZE = AttributeDefinition.builder("size", -1L).build();
    public static final AttributeDefinition<EvictionType> EVICTION_TYPE = AttributeDefinition.builder("type", EvictionType.COUNT).build();
    private final Attribute<Long> size;
    private final Attribute<EvictionType> evictionType;
    private final Attribute<StorageType> storageType;
    private final Attribute<Integer> addressCount;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(MemoryConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), STORAGE_TYPE, SIZE, EVICTION_TYPE, ADDRESS_COUNT);
    }

    MemoryConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
        this.storageType = attributes.attribute(STORAGE_TYPE);
        this.size = attributes.attribute(SIZE);
        this.evictionType = attributes.attribute(EVICTION_TYPE);
        this.addressCount = attributes.attribute(ADDRESS_COUNT);
    }

    public StorageType storageType() {
        return this.storageType.get();
    }

    public long size() {
        return this.size.get();
    }

    public void size(long newSize) {
        this.size.set(newSize);
    }

    public EvictionType evictionType() {
        return this.evictionType.get();
    }

    public int addressCount() {
        return this.addressCount.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "MemoryConfiguration [attributes=" + this.attributes + "]";
    }
}

