/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StripedLock {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int HASH_BITS = Integer.MAX_VALUE;
    private final ReadWriteLock[] locks;

    public StripedLock() {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public StripedLock(int lockCount) {
        this.locks = new ReadWriteLock[StripedLock.tableSizeFor(lockCount)];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    public ReadWriteLock getLock(Object obj) {
        int h = StripedLock.spread(obj.hashCode());
        int offset = h & this.locks.length - 1;
        return this.locks[offset];
    }

    public ReadWriteLock getLockWithOffset(int offset) {
        if (offset >= this.locks.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.locks[offset];
    }

    void lockAll() {
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i].writeLock().lock();
        }
    }

    void unlockAll() {
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i].writeLock().unlock();
        }
    }

    private static final int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    static final int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }
}

