/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedDistributionInterceptor
extends TxDistributionInterceptor {
    private static final Log log = LogFactory.getLog(VersionedDistributionInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected CompletableFuture<Object> prepareOnAffectedNodes(TxInvocationContext<?> ctx, PrepareCommand command, Collection<Address> recipients) {
        CompletableFuture<Map<Address, Response>> remoteInvocation = this.rpcManager.invokeRemotelyAsync(recipients, command, this.createPrepareRpcOptions());
        return remoteInvocation.handle((responses, t) -> {
            VersionedDistributionInterceptor.transactionRemotelyPrepared(ctx);
            CompletableFutures.rethrowException(t);
            this.checkTxCommandResponses((Map<Address, Response>)responses, command, (TxInvocationContext<LocalTransaction>)ctx, recipients);
            Object ct = ctx.getCacheTransaction();
            for (Response r : responses.values()) {
                WriteSkewHelper.readVersionsFromResponse(r, ct);
            }
            return null;
        });
    }
}

