/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.locks.LockUtil;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.logging.Log;

public abstract class AbstractTxLockingInterceptor
extends AbstractLockingInterceptor {
    protected boolean trace = this.getLog().isTraceEnabled();
    protected RpcManager rpcManager;
    private PartitionHandlingManager partitionHandlingManager;
    private PendingLockManager pendingLockManager;

    @Inject
    public void setDependencies(RpcManager rpcManager, PartitionHandlingManager partitionHandlingManager, PendingLockManager pendingLockManager) {
        this.rpcManager = rpcManager;
        this.partitionHandlingManager = partitionHandlingManager;
        this.pendingLockManager = pendingLockManager;
    }

    @Override
    public BasicInvocationStage visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.invokeNext(ctx, command).handle(this.unlockAllReturnHandler);
    }

    @Override
    public BasicInvocationStage visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return this.visitNonTxDataWriteCommand(ctx, command);
        }
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        if (ctx.isInTxScope()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNext(ctx, command).handle(this.unlockAllReturnHandler);
    }

    @Override
    public BasicInvocationStage visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNext(ctx, command).handle((rCtx, rCommand, rv, t) -> {
            if (t instanceof OutdatedTopologyException) {
                throw t;
            }
            this.releaseLockOnTxCompletion((TxInvocationContext)rCtx);
        });
    }

    protected final boolean lockOrRegisterBackupLock(TxInvocationContext<?> ctx, Object key, long lockTimeout) throws InterruptedException {
        switch (LockUtil.getLockOwnership(key, this.cdl)) {
            case PRIMARY: {
                if (this.trace) {
                    this.getLog().tracef("Acquiring locks on %s.", (Object)Util.toStr(key));
                }
                this.checkPendingAndLockKey(ctx, key, lockTimeout);
                return true;
            }
            case BACKUP: {
                if (this.trace) {
                    this.getLog().tracef("Acquiring backup locks on %s.", key);
                }
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
                return false;
            }
        }
        return false;
    }

    protected final Collection<Object> lockAllOrRegisterBackupLock(TxInvocationContext<?> ctx, Collection<?> keys, long lockTimeout) throws InterruptedException {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        Log log = this.getLog();
        ArrayList<Object> keysToLock = new ArrayList<Object>(keys.size());
        for (Object key : keys) {
            switch (LockUtil.getLockOwnership(key, this.cdl)) {
                case PRIMARY: {
                    if (this.trace) {
                        log.tracef("Acquiring locks on %s.", (Object)Util.toStr(key));
                    }
                    keysToLock.add(key);
                    break;
                }
                case BACKUP: {
                    if (this.trace) {
                        log.tracef("Acquiring backup locks on %s.", (Object)Util.toStr(key));
                    }
                    ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
                    break;
                }
            }
        }
        if (keysToLock.isEmpty()) {
            return Collections.emptyList();
        }
        this.checkPendingAndLockAllKeys(ctx, keysToLock, lockTimeout);
        return keysToLock;
    }

    private void checkPendingAndLockKey(InvocationContext ctx, Object key, long lockTimeout) throws InterruptedException {
        long remaining = this.pendingLockManager.awaitPendingTransactionsForKey((TxInvocationContext)ctx, key, lockTimeout, TimeUnit.MILLISECONDS);
        this.lockAndRecord(ctx, key, remaining);
    }

    private void checkPendingAndLockAllKeys(InvocationContext ctx, Collection<Object> keys, long lockTimeout) throws InterruptedException {
        long remaining = this.pendingLockManager.awaitPendingTransactionsForAllKeys((TxInvocationContext)ctx, keys, lockTimeout, TimeUnit.MILLISECONDS);
        this.lockAllAndRecord(ctx, keys, remaining);
    }

    protected void releaseLockOnTxCompletion(TxInvocationContext ctx) {
        boolean shouldReleaseLocks;
        boolean bl = shouldReleaseLocks = ctx.isOriginLocal() && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction()) || !ctx.isOriginLocal() && Configurations.isSecondPhaseAsync(this.cacheConfiguration);
        if (shouldReleaseLocks) {
            this.lockManager.unlockAll(ctx);
        }
    }
}

