/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.concurrent.Executor;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

class CustomRequestCorrelator
extends RequestCorrelator {
    private final Executor remoteExecutor;
    private final StreamingMarshaller ispnMarshaller;

    public CustomRequestCorrelator(Protocol transport, RequestHandler handler, Address local_addr, Executor remoteExecutor, StreamingMarshaller ispnMarshaller) {
        super(ClassConfigurator.getProtocolId(RequestCorrelator.class), transport, handler, local_addr);
        this.remoteExecutor = remoteExecutor;
        this.ispnMarshaller = ispnMarshaller;
    }

    @Override
    protected void handleResponse(Request req, Address sender, byte[] buf, int offset, int length, boolean is_exception) {
        Object retval;
        if (length == 0) {
            retval = CacheNotFoundResponse.INSTANCE;
        } else {
            try {
                retval = this.ispnMarshaller.objectFromByteBuffer(buf, offset, length);
            }
            catch (Exception e) {
                log.error(Util.getMessage("FailedUnmarshallingBufferIntoReturnValue"), e);
                retval = e;
                is_exception = true;
            }
        }
        req.receiveResponse(retval, sender, is_exception);
    }

    @Override
    public void receiveView(View new_view) {
        this.remoteExecutor.execute(() -> super.receiveView(new_view));
    }
}

