/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.ImmutableListCopy;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractCacheTransaction
implements CacheTransaction {
    protected final GlobalTransaction tx;
    private static Log log = LogFactory.getLog(AbstractCacheTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int INITIAL_LOCK_CAPACITY = 4;
    protected volatile boolean hasLocalOnlyModifications;
    protected volatile List<WriteCommand> modifications;
    protected Map<Object, CacheEntry> lookedUpEntries;
    protected Set<Object> affectedKeys = null;
    private final AtomicReference<Set<Object>> lockedKeys = new AtomicReference();
    private final AtomicReference<Set<Object>> backupKeyLocks = new AtomicReference();
    protected final int topologyId;
    private EntryVersionsMap updatedEntryVersions;
    private EntryVersionsMap versionsSeenMap;
    private volatile boolean isMarkedForRollback;
    private final long txCreationTime;
    protected final Equivalence<Object> keyEquivalence;
    private volatile Flag stateTransferFlag;
    private final CompletableFuture<Void> txCompleted;
    private volatile CompletableFuture<Void> backupLockReleased;

    @Override
    public final boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    @Override
    public void markForRollback(boolean markForRollback) {
        this.isMarkedForRollback = markForRollback;
    }

    public AbstractCacheTransaction(GlobalTransaction tx, int topologyId, Equivalence<Object> keyEquivalence, long txCreationTime) {
        this.tx = tx;
        this.topologyId = topologyId;
        this.keyEquivalence = keyEquivalence;
        this.txCreationTime = txCreationTime;
        this.txCompleted = new CompletableFuture();
        this.backupLockReleased = new CompletableFuture();
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.tx;
    }

    @Override
    public final List<WriteCommand> getModifications() {
        if (this.hasLocalOnlyModifications) {
            return this.modifications.stream().filter(cmd -> !cmd.hasFlag(Flag.CACHE_MODE_LOCAL)).collect(Collectors.toList());
        }
        return this.getAllModifications();
    }

    @Override
    public final List<WriteCommand> getAllModifications() {
        if (this.modifications instanceof ImmutableListCopy) {
            return this.modifications;
        }
        if (this.modifications == null) {
            return Collections.emptyList();
        }
        return Immutables.immutableListCopy(this.modifications);
    }

    public final void setModifications(List<WriteCommand> modifications) {
        if (modifications == null) {
            throw new IllegalArgumentException("modification list cannot be null");
        }
        ArrayList<WriteCommand> mods = new ArrayList<WriteCommand>();
        for (WriteCommand cmd : modifications) {
            if (cmd.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                this.hasLocalOnlyModifications = true;
            }
            mods.add(cmd);
        }
        this.modifications = Collections.synchronizedList(mods);
    }

    @Override
    public final boolean hasModification(Class<?> modificationClass) {
        if (this.modifications != null) {
            for (WriteCommand mod : this.getModifications()) {
                if (!modificationClass.isAssignableFrom(mod.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void freezeModifications() {
        this.modifications = this.modifications != null ? Immutables.immutableListCopy(this.modifications) : Collections.emptyList();
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries;
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (this.lookedUpEntries == null) {
            return null;
        }
        return this.lookedUpEntries.get(key);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.remove(key);
        }
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries = null;
    }

    @Override
    public boolean ownsLock(Object key) {
        return this.getLockedKeys().contains(key);
    }

    @Override
    public void notifyOnTransactionFinished() {
        if (trace) {
            log.tracef("Transaction %s has completed, notifying listening threads.", (Object)this.tx);
        }
        if (!this.txCompleted.isDone()) {
            this.txCompleted.complete(null);
            this.cleanupBackupLocks();
        }
    }

    @Override
    public final boolean waitForLockRelease(long lockAcquisitionTimeout) throws InterruptedException {
        return CompletableFutures.await(this.txCompleted, lockAcquisitionTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void addBackupLockForKey(Object key) {
        Set<Object> keys = this.backupKeyLocks.updateAndGet(value -> value == null ? Collections.synchronizedSet(new HashSet(4)) : value);
        keys.add(key);
    }

    public void registerLockedKey(Object key) {
        Set<Object> keys = this.lockedKeys.updateAndGet(value -> value == null ? Collections.synchronizedSet(CollectionFactory.makeSet(4, this.keyEquivalence)) : value);
        if (trace) {
            log.tracef("Registering locked key: %s", (Object)Util.toStr(key));
        }
        keys.add(key);
    }

    @Override
    public Set<Object> getLockedKeys() {
        Set<Object> keys = this.lockedKeys.get();
        return keys == null ? Collections.emptySet() : keys;
    }

    @Override
    public Set<Object> getBackupLockedKeys() {
        Set<Object> keys = this.backupKeyLocks.get();
        return keys == null ? Collections.emptySet() : keys;
    }

    @Override
    public void clearLockedKeys() {
        if (trace) {
            log.tracef("Clearing locked keys: %s", (Object)Util.toStr(this.lockedKeys.get()));
        }
        this.lockedKeys.set(null);
    }

    @Override
    public boolean containsLockOrBackupLock(Object key) {
        return this.getLockedKeys().contains(key) || this.getBackupLockedKeys().contains(key);
    }

    @Override
    public Object findAnyLockedOrBackupLocked(Collection<Object> keys) {
        Set<Object> lockedKeysCopy = this.getLockedKeys();
        Set<Object> backupKeyLocksCopy = this.getBackupLockedKeys();
        for (Object key : keys) {
            if (!lockedKeysCopy.contains(key) && !backupKeyLocksCopy.contains(key)) continue;
            return key;
        }
        return null;
    }

    @Override
    public boolean areLocksReleased() {
        return this.txCompleted.isDone();
    }

    public Set<Object> getAffectedKeys() {
        return this.affectedKeys == null ? Collections.emptySet() : this.affectedKeys;
    }

    public void addAffectedKey(Object key) {
        this.initAffectedKeys();
        this.affectedKeys.add(key);
    }

    public void addAllAffectedKeys(Collection<?> keys) {
        this.initAffectedKeys();
        this.affectedKeys.addAll(keys);
    }

    private void initAffectedKeys() {
        if (this.affectedKeys == null) {
            this.affectedKeys = CollectionFactory.makeSet(4, this.keyEquivalence);
        }
    }

    @Override
    public EntryVersionsMap getUpdatedEntryVersions() {
        return this.updatedEntryVersions;
    }

    @Override
    public void setUpdatedEntryVersions(EntryVersionsMap updatedEntryVersions) {
        this.updatedEntryVersions = updatedEntryVersions;
    }

    @Override
    public void addReadKey(Object key) {
    }

    @Override
    public boolean keyRead(Object key) {
        return false;
    }

    @Override
    public void addVersionRead(Object key, EntryVersion version) {
        if (version == null) {
            return;
        }
        if (this.versionsSeenMap == null) {
            this.versionsSeenMap = new EntryVersionsMap();
        }
        if (!this.versionsSeenMap.containsKey(key)) {
            if (trace) {
                log.tracef("Transaction %s read %s with version %s", (Object)this.getGlobalTransaction().globalId(), key, (Object)version);
            }
            this.versionsSeenMap.put(key, (IncrementableEntryVersion)version);
        }
    }

    @Override
    public EntryVersionsMap getVersionsRead() {
        return this.versionsSeenMap == null ? new EntryVersionsMap() : this.versionsSeenMap;
    }

    public final boolean isFromStateTransfer() {
        return this.stateTransferFlag != null;
    }

    public final Flag getStateTransferFlag() {
        return this.stateTransferFlag;
    }

    public abstract void setStateTransferFlag(Flag var1);

    protected final void internalSetStateTransferFlag(Flag stateTransferFlag) {
        this.stateTransferFlag = stateTransferFlag;
    }

    @Override
    public long getCreationTime() {
        return this.txCreationTime;
    }

    @Override
    public final void addListener(CacheTransaction.TransactionCompletedListener listener) {
        this.txCompleted.thenRun(listener::onCompletion);
    }

    @Override
    public CompletableFuture<Void> getReleaseFutureForKey(Object key) {
        if (this.getLockedKeys().contains(key)) {
            return this.txCompleted;
        }
        if (this.getBackupLockedKeys().contains(key)) {
            return this.backupLockReleased;
        }
        return null;
    }

    @Override
    public KeyValuePair<Object, CompletableFuture<Void>> getReleaseFutureForKeys(Collection<Object> keys) {
        Set<Object> locked = this.getLockedKeys();
        Set<Object> backupLocked = this.getBackupLockedKeys();
        Object backupKey = null;
        for (Object key : keys) {
            if (locked.contains(key)) {
                return new KeyValuePair<Object, CompletableFuture<Void>>(key, this.txCompleted);
            }
            if (!backupLocked.contains(key)) continue;
            backupKey = key;
        }
        return backupKey == null ? null : new KeyValuePair<Object, CompletableFuture<Void>>(backupKey, this.backupLockReleased);
    }

    @Override
    public void cleanupBackupLocks() {
        this.backupKeyLocks.getAndUpdate(value -> {
            if (value != null) {
                this.backupLockReleased.complete(null);
                this.backupLockReleased = new CompletableFuture();
                value.clear();
            }
            return value;
        });
    }
}

