/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.dns;

import java.util.logging.Level;
import java.util.logging.Logger;

public class DnsRecord
implements Comparable<DnsRecord> {
    private static final Logger log = Logger.getLogger(DnsRecord.class.getName());
    private final int priority;
    private final int weight;
    private final int port;
    private final String host;

    public DnsRecord(int priority, int weight, int port, String host) {
        this.priority = priority;
        this.weight = weight;
        this.port = port;
        this.host = host.replaceAll("\\.$", "");
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Created %s", this));
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public static DnsRecord fromString(String input) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Creating DnsRecord from [%s]", input));
        }
        String[] splitted = input.split(" ");
        return new DnsRecord(Integer.parseInt(splitted[0]), Integer.parseInt(splitted[1]), Integer.parseInt(splitted[2]), splitted[3]);
    }

    public String toString() {
        return "DnsRecord{priority=" + this.priority + ", weight=" + this.weight + ", port=" + this.port + ", host='" + this.host + '\'' + '}';
    }

    @Override
    public int compareTo(DnsRecord o) {
        if (this.getPriority() < o.getPriority()) {
            return -1;
        }
        return 1;
    }
}

