/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.Bits;

public class FragHeader
extends Header {
    public long id;
    public int frag_id;
    public int num_frags;

    public FragHeader() {
    }

    public FragHeader(long id, int frag_id, int num_frags) {
        this.id = id;
        this.frag_id = frag_id;
        this.num_frags = num_frags;
    }

    @Override
    public short getMagicId() {
        return 52;
    }

    @Override
    public Supplier<? extends Header> create() {
        return FragHeader::new;
    }

    @Override
    public String toString() {
        return "[id=" + this.id + ", frag_id=" + this.frag_id + ", num_frags=" + this.num_frags + ']';
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        Bits.writeLong(this.id, out);
        Bits.writeInt(this.frag_id, out);
        Bits.writeInt(this.num_frags, out);
    }

    @Override
    public int serializedSize() {
        return Bits.size(this.id) + Bits.size(this.frag_id) + Bits.size(this.num_frags);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.id = Bits.readLong(in);
        this.frag_id = Bits.readInt(in);
        this.num_frags = Bits.readInt(in);
    }
}

