/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletableFutures;

public class BackupMultiKeyAckCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 41;
    private CommandInvocationId commandInvocationId;
    private CommandAckCollector commandAckCollector;
    private int segment;
    private int topologyId;

    public BackupMultiKeyAckCommand() {
        super(null);
    }

    public BackupMultiKeyAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public BackupMultiKeyAckCommand(ByteString cacheName, CommandInvocationId commandInvocationId, int segment, int topologyId) {
        super(cacheName);
        this.commandInvocationId = commandInvocationId;
        this.segment = segment;
        this.topologyId = topologyId;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.commandAckCollector.multiKeyBackupAck(this.commandInvocationId, this.getOrigin(), this.segment, this.topologyId);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 41;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeInt(this.segment);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.segment = input.readInt();
        this.topologyId = input.readInt();
    }

    public void setCommandAckCollector(CommandAckCollector commandAckCollector) {
        this.commandAckCollector = commandAckCollector;
    }

    @Override
    public String toString() {
        return "BackupMultiKeyAckCommand{commandInvocationId=" + this.commandInvocationId + ", segment=" + this.segment + ", topologyId=" + this.topologyId + '}';
    }
}

