/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RepeatableReadEntry
extends ReadCommittedEntry {
    private static final Log log = LogFactory.getLog(RepeatableReadEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object initialValue;
    protected Object oldValue;

    public RepeatableReadEntry(Object key, Object value, Metadata metadata) {
        super(key, value, metadata);
        this.initialValue = value;
        this.oldValue = value;
    }

    public void performLocalWriteSkewCheck(DataContainer container, boolean alreadyCopied) {
        InternalCacheEntry ice = container.get(this.key);
        Object actualValue = ice == null ? null : ice.getValue();
        Object valueToCompare = this.initialValue;
        if (trace) {
            log.tracef("Performing local write skew check. actualValue=%s, transactionValue=%s", (Object)actualValue, valueToCompare);
        }
        if (actualValue != null && actualValue != valueToCompare) {
            log.unableToCopyEntryForUpdate(this.getKey());
            throw new WriteSkewException("Detected write skew.", this.key);
        }
        if (valueToCompare != null && ice == null && !this.isCreated()) {
            log.unableToCopyEntryForUpdate(this.getKey());
            throw new WriteSkewException("Detected write skew - concurrent removal of entry!", this.key);
        }
    }

    @Override
    public void setSkipLookup(boolean skipLookup) {
        this.setFlag(skipLookup, ReadCommittedEntry.Flags.SKIP_LOOKUP);
    }

    @Override
    public boolean skipLookup() {
        return this.isFlagSet(ReadCommittedEntry.Flags.SKIP_LOOKUP);
    }

    @Override
    public RepeatableReadEntry clone() {
        return (RepeatableReadEntry)super.clone();
    }

    @Override
    public final Object setValue(Object value) {
        super.setValue(value);
        this.setSkipLookup(true);
        return this.oldValue;
    }

    @Override
    public void resetCurrentValue() {
        this.value = this.oldValue;
    }

    @Override
    public void updatePreviousValue() {
        this.oldValue = this.value;
    }
}

