/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.stream.LongStream;
import org.infinispan.container.offheap.UnsafeHolder;
import sun.misc.Unsafe;

public class MemoryAddressHash {
    private static final Unsafe UNSAFE = UnsafeHolder.UNSAFE;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int HASH_BITS = Integer.MAX_VALUE;
    private final long memory;
    private final int pointerCount;

    public MemoryAddressHash(int pointers) {
        this.pointerCount = MemoryAddressHash.nextPowerOfTwo(pointers);
        long bytes = (long)this.pointerCount << 3;
        this.memory = UNSAFE.allocateMemory(bytes);
        UNSAFE.setMemory(this.memory, bytes, (byte)0);
    }

    private int findOffset(Object instance) {
        int h = MemoryAddressHash.spread(instance.hashCode());
        int pointerMask = this.pointerCount - 1;
        return h & pointerMask;
    }

    public void putMemoryAddress(Object instance, long address) {
        int offset = this.findOffset(instance);
        UNSAFE.putLong(this.memory + ((long)offset << 3), address);
    }

    public long getMemoryAddress(Object instance) {
        return UNSAFE.getLong(this.memory + (long)(this.findOffset(instance) << 3));
    }

    public long getMemoryAddressOffset(int offset) {
        return UNSAFE.getLong(this.memory + ((long)offset << 3));
    }

    public void deallocate() {
        UNSAFE.freeMemory(this.memory);
    }

    public LongStream toStream() {
        return LongStream.iterate(this.memory, l -> l + 8L).limit(this.pointerCount).map(UNSAFE::getLong).filter(l -> l != 0L);
    }

    public LongStream toStreamRemoved() {
        return LongStream.iterate(this.memory, l -> l + 8L).limit(this.pointerCount).map(l -> UNSAFE.getAndSetLong(null, l, 0L)).filter(l -> l != 0L);
    }

    private static final int nextPowerOfTwo(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    static final int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }
}

