/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationComposeHandler;
import org.infinispan.interceptors.InvocationComposeSuccessHandler;
import org.infinispan.interceptors.InvocationExceptionHandler;
import org.infinispan.interceptors.InvocationFinallyHandler;
import org.infinispan.interceptors.InvocationReturnValueHandler;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessHandler;
import org.infinispan.interceptors.impl.AbstractInvocationStage;
import org.infinispan.interceptors.impl.BasicAsyncInvocationStage;
import org.infinispan.interceptors.impl.ExceptionStage;
import org.infinispan.interceptors.impl.ReturnValueStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AsyncInvocationStage
implements InvocationStage,
InvocationComposeHandler,
BiConsumer<Object, Throwable> {
    private static final Log log = LogFactory.getLog(AsyncInvocationStage.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InvocationContext ctx;
    private final VisitableCommand command;
    private final CompletableFuture<Object> future = new CompletableFuture();
    private static final int HANDLERS_DEQUE_CAPACITY = 8;
    private InvocationComposeHandler[] handlers = new InvocationComposeHandler[8];
    private byte mask = (byte)7;
    private byte head;
    private byte tail;
    private boolean frozen;

    public AsyncInvocationStage(InvocationContext ctx, VisitableCommand command, CompletableFuture<?> valueFuture) {
        this.ctx = ctx;
        this.command = command;
        valueFuture.whenComplete((BiConsumer)this);
    }

    @Override
    public Object get() throws Throwable {
        this.freezeHandlers();
        try {
            return CompletableFutures.await(this.future);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Override
    public boolean isDone() {
        this.freezeHandlers();
        return this.future.isDone();
    }

    @Override
    public InvocationStage compose(InvocationComposeHandler composeHandler) {
        InvocationStage stage;
        if (this.addHandler(composeHandler)) {
            return this;
        }
        if (this.future.isDone()) {
            try {
                Object rv = this.future.getNow(null);
                stage = new ReturnValueStage(this.ctx, this.command, rv);
            }
            catch (Throwable t) {
                stage = new ExceptionStage(this.ctx, this.command, CompletableFutures.extractException(t));
            }
        } else {
            stage = new AsyncInvocationStage(this.ctx, this.command, this.toCompletableFuture());
        }
        return stage.compose(composeHandler);
    }

    @Override
    public InvocationStage thenCompose(InvocationComposeSuccessHandler thenComposeHandler) {
        return this.compose(thenComposeHandler);
    }

    @Override
    public InvocationStage thenAccept(InvocationSuccessHandler successHandler) {
        return this.compose(successHandler);
    }

    @Override
    public InvocationStage thenApply(InvocationReturnValueHandler returnValueHandler) {
        return this.compose(returnValueHandler);
    }

    @Override
    public InvocationStage exceptionally(InvocationExceptionHandler exceptionHandler) {
        return this.compose(exceptionHandler);
    }

    @Override
    public InvocationStage handle(InvocationFinallyHandler finallyHandler) {
        return this.compose(finallyHandler);
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        this.freezeHandlers();
        return this.future;
    }

    @Override
    public InvocationStage toInvocationStage(InvocationContext newCtx, VisitableCommand newCommand) {
        if (newCtx != this.ctx || newCommand != this.command) {
            this.freezeHandlers();
            return new AsyncInvocationStage(newCtx, newCommand, this.future);
        }
        return this;
    }

    @Override
    public void accept(Object rv, Throwable t) {
        if (trace) {
            log.tracef("Resuming invocation of command %s with %d handlers", (Object)this.command, (Object)this.handlersSize());
        }
        AbstractInvocationStage currentStage = t != null ? new ExceptionStage(this.ctx, this.command, CompletableFutures.extractException(t)) : new ReturnValueStage(this.ctx, this.command, rv);
        this.invokeHandlers(currentStage);
    }

    @Override
    public BasicInvocationStage apply(BasicInvocationStage stage, InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) throws Throwable {
        this.invokeHandlers(stage.toInvocationStage(this.ctx, this.command));
        return stage;
    }

    private void invokeHandlers(InvocationStage currentStage) {
        while (true) {
            InvocationComposeHandler handler;
            if ((handler = this.pollHandler()) == null) {
                this.completeFromStage(currentStage);
                return;
            }
            if ((currentStage = currentStage.compose(handler)).isDone()) continue;
            if (currentStage instanceof BasicAsyncInvocationStage) {
                currentStage.toCompletableFuture().whenComplete((BiConsumer)this);
                return;
            }
            if (currentStage instanceof AsyncInvocationStage) {
                AsyncInvocationStage asyncInvocationStage = (AsyncInvocationStage)currentStage;
                asyncInvocationStage.whenComplete(this);
                return;
            }
            currentStage = new ExceptionStage(this.ctx, this.command, new IllegalStateException("Unsupported asynchronous stage type: " + currentStage));
        }
    }

    private void completeFromStage(BasicInvocationStage stage) {
        if (!stage.isDone()) {
            throw new IllegalArgumentException("Stage must be done");
        }
        try {
            Object rv = stage.get();
            this.future.complete(rv);
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
        }
    }

    private void whenComplete(AsyncInvocationStage otherStage) {
        if (this.addHandler(otherStage)) {
            return;
        }
        this.future.whenComplete((BiConsumer)otherStage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freezeHandlers() {
        AsyncInvocationStage asyncInvocationStage = this;
        synchronized (asyncInvocationStage) {
            this.frozen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addHandler(InvocationComposeHandler composeHandler) {
        AsyncInvocationStage asyncInvocationStage = this;
        synchronized (asyncInvocationStage) {
            if (this.frozen) {
                return false;
            }
            this.handlers[this.tail & this.mask] = composeHandler;
            this.tail = (byte)(this.tail + 1);
            if ((this.tail - this.head & this.mask) == 0) {
                this.frozen = true;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvocationComposeHandler pollHandler() {
        InvocationComposeHandler handler;
        AsyncInvocationStage asyncInvocationStage = this;
        synchronized (asyncInvocationStage) {
            if (this.tail != this.head) {
                handler = this.handlers[this.head & this.mask];
                this.head = (byte)(this.head + 1);
            } else {
                handler = null;
                this.freezeHandlers();
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handlersSize() {
        AsyncInvocationStage asyncInvocationStage = this;
        synchronized (asyncInvocationStage) {
            return this.tail - this.head;
        }
    }
}

