/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationComposeHandler;
import org.infinispan.interceptors.InvocationComposeSuccessHandler;
import org.infinispan.interceptors.InvocationExceptionHandler;
import org.infinispan.interceptors.InvocationFinallyHandler;
import org.infinispan.interceptors.InvocationReturnValueHandler;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessHandler;
import org.infinispan.interceptors.impl.AbstractInvocationStage;
import org.infinispan.interceptors.impl.ReturnValueStage;
import org.infinispan.interceptors.impl.Stages;
import org.infinispan.util.concurrent.CompletableFutures;

public class ExceptionStage
extends AbstractInvocationStage {
    Throwable throwable;

    public ExceptionStage(InvocationContext ctx, VisitableCommand command, Throwable throwable) {
        super(ctx, command);
        this.throwable = throwable;
    }

    @Override
    public InvocationStage compose(InvocationComposeHandler composeHandler) {
        try {
            BasicInvocationStage stage = composeHandler.apply(this, this.ctx, this.command, null, this.throwable);
            return stage.toInvocationStage(this.ctx, this.command);
        }
        catch (Throwable t) {
            if (this.throwable != t) {
                t.addSuppressed(this.throwable);
                this.throwable = t;
            }
            return this;
        }
    }

    @Override
    public InvocationStage thenCompose(InvocationComposeSuccessHandler thenComposeHandler) {
        return this.compose(thenComposeHandler);
    }

    @Override
    public InvocationStage thenAccept(InvocationSuccessHandler successHandler) {
        return this;
    }

    @Override
    public InvocationStage thenApply(InvocationReturnValueHandler returnValueHandler) {
        return this;
    }

    @Override
    public InvocationStage exceptionally(InvocationExceptionHandler exceptionHandler) {
        try {
            Object rv = exceptionHandler.apply(this.ctx, this.command, this.throwable);
            return new ReturnValueStage(this.ctx, this.command, rv);
        }
        catch (Throwable t) {
            if (t != this.throwable) {
                t.addSuppressed(this.throwable);
                this.throwable = t;
            }
            return this;
        }
    }

    @Override
    public InvocationStage handle(InvocationFinallyHandler finallyHandler) {
        try {
            finallyHandler.accept(this.ctx, this.command, null, this.throwable);
            return this;
        }
        catch (Throwable t) {
            if (t != this.throwable) {
                t.addSuppressed(this.throwable);
                this.throwable = t;
            }
            return this;
        }
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return CompletableFutures.completedExceptionFuture(this.throwable);
    }

    @Override
    public Object get() throws Throwable {
        throw this.throwable;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    public String toString() {
        return "ExceptionStage(" + Stages.className(this.throwable) + ")";
    }
}

