/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.AnnotationParserException;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.config.AnnotationAttributeConfiguration;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.impl.parser.AnnotationParser;

public abstract class AnnotatedDescriptorImpl
implements AnnotatedDescriptor {
    protected final String name;
    protected String fullName;
    protected final String documentation;
    protected Map<String, AnnotationElement.Annotation> annotations = null;
    protected Map<String, Object> processedAnnotations = null;

    protected AnnotatedDescriptorImpl(String name, String fullName, String documentation) {
        if (name.indexOf(46) != -1) {
            throw new DescriptorParserException("Definition names should not be qualified : " + name);
        }
        this.name = name;
        this.fullName = fullName;
        this.documentation = documentation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    private void processAnnotations() throws AnnotationParserException {
        if (this.annotations == null) {
            if (this.documentation != null) {
                AnnotationParser parser = new AnnotationParser(this.documentation, true);
                List<AnnotationElement.Annotation> parsedAnnotations = parser.parse();
                LinkedHashMap<String, AnnotationElement.Annotation> _annotations = new LinkedHashMap<String, AnnotationElement.Annotation>();
                LinkedHashMap<String, AnnotationElement.Annotation> containers = new LinkedHashMap<String, AnnotationElement.Annotation>();
                for (AnnotationElement.Annotation annotation : parsedAnnotations) {
                    AnnotationConfiguration annotationConfig = this.getAnnotationConfig(annotation.getName());
                    if (annotationConfig != null) {
                        this.validateAttributes(annotation, annotationConfig);
                        this.normalizeValues(annotation, annotationConfig);
                    }
                    if (_annotations.containsKey(annotation.getName()) || containers.containsKey(annotation.getName())) {
                        if (annotationConfig != null && annotationConfig.repeatable() != null) {
                            AnnotationElement.Annotation container = (AnnotationElement.Annotation)containers.get(annotation.getName());
                            if (container == null) {
                                LinkedList<AnnotationElement.Value> values = new LinkedList<AnnotationElement.Value>();
                                values.add((AnnotationElement.Value)_annotations.remove(annotation.getName()));
                                values.add(annotation);
                                AnnotationElement.Attribute value = new AnnotationElement.Attribute(annotation.position, "value", new AnnotationElement.Array(annotation.position, values));
                                container = new AnnotationElement.Annotation(annotation.position, annotationConfig.repeatable(), Collections.singletonMap(value.getName(), value));
                                containers.put(annotation.getName(), container);
                                _annotations.put(container.getName(), container);
                                continue;
                            }
                            AnnotationElement.Array value = (AnnotationElement.Array)container.getAttributeValue("value");
                            value.getValues().add(annotation);
                            continue;
                        }
                        throw new AnnotationParserException(String.format("Error: %s: duplicate annotation definition \"%s\"", AnnotationElement.positionToString(annotation.position), annotation.getName()));
                    }
                    _annotations.put(annotation.getName(), annotation);
                }
                this.annotations = _annotations.isEmpty() ? Collections.emptyMap() : _annotations;
                LinkedHashMap _processedAnnotations = new LinkedHashMap();
                for (AnnotationElement.Annotation annotation : this.annotations.values()) {
                    AnnotationConfiguration annotationConfig = this.getAnnotationConfig(annotation.getName());
                    if (annotationConfig == null || annotationConfig.metadataCreator() == null) continue;
                    AnnotationMetadataCreator<?, AnnotatedDescriptor> annotationMetadataCreator = annotationConfig.metadataCreator();
                    Object metadataForAnnotation = annotationMetadataCreator.create(this, annotation);
                    _processedAnnotations.put(annotation.getName(), metadataForAnnotation);
                }
                this.processedAnnotations = _processedAnnotations.isEmpty() ? Collections.emptyMap() : _processedAnnotations;
            } else {
                this.annotations = Collections.emptyMap();
                this.processedAnnotations = Collections.emptyMap();
            }
        }
    }

    private void validateAttributes(AnnotationElement.Annotation annotation, AnnotationConfiguration annotationConfig) {
        for (Map.Entry<String, AnnotationElement.Attribute> entry : annotation.getAttributes().entrySet()) {
            AnnotationElement.Attribute attribute = entry.getValue();
            AnnotationAttributeConfiguration attributeConfig = annotationConfig.attributes().get(attribute.getName());
            if (attributeConfig == null) {
                throw new AnnotationParserException("Unexpected attribute '" + attribute.getName() + "' in annotation '" + annotation.getName() + "' on " + this.getFullName());
            }
            AnnotationElement.Value value = attribute.getValue();
            if (!attributeConfig.multiple() && value instanceof AnnotationElement.Array) {
                throw new AnnotationParserException("Annotation attribute '" + attribute.getName() + "' in annotation '" + annotation.getName() + "' on " + this.getFullName() + " does not accept array values");
            }
            if (value instanceof AnnotationElement.Array) {
                for (AnnotationElement.Value v : ((AnnotationElement.Array)value).getValues()) {
                    this.validateAttribute(annotation, attribute, attributeConfig, v);
                }
                continue;
            }
            this.validateAttribute(annotation, attribute, attributeConfig, value);
        }
    }

    private void validateAttribute(AnnotationElement.Annotation annotation, AnnotationElement.Attribute attribute, AnnotationAttributeConfiguration attributeConfig, AnnotationElement.Value value) {
        switch (attributeConfig.type()) {
            case IDENTIFIER: {
                if (!(value instanceof AnnotationElement.Identifier)) {
                    throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be an identifier");
                }
                if (attributeConfig.allowedValues() == null || attributeConfig.allowedValues().contains(value.getValue())) break;
                throw new AnnotationParserException("Annotation attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " should have one of the values : " + attributeConfig.allowedValues());
            }
            case STRING: {
                if (!(value instanceof AnnotationElement.Literal) || !(value.getValue() instanceof String)) {
                    throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a String");
                }
                if (attributeConfig.allowedValues() == null || attributeConfig.allowedValues().contains(value.getValue())) break;
                throw new AnnotationParserException("Annotation attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " should have one of the values : " + attributeConfig.allowedValues());
            }
            case CHARACTER: {
                if (value instanceof AnnotationElement.Literal && value.getValue() instanceof Character) break;
                throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a char");
            }
            case BOOLEAN: {
                if (value instanceof AnnotationElement.Literal && value.getValue() instanceof Boolean) break;
                throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a boolean");
            }
            case INT: {
                if (value instanceof AnnotationElement.Literal && value.getValue() instanceof Integer) break;
                throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be an int");
            }
            case LONG: {
                if (value instanceof AnnotationElement.Literal && value.getValue() instanceof Long) break;
                throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a long");
            }
            case FLOAT: {
                if (value instanceof AnnotationElement.Literal && value.getValue() instanceof Float) break;
                throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a float");
            }
            case DOUBLE: {
                if (value instanceof AnnotationElement.Literal && value.getValue() instanceof Double) break;
                throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a double");
            }
            case ANNOTATION: {
                if (value instanceof AnnotationElement.Annotation) break;
                throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be an annotation");
            }
        }
    }

    private void normalizeValues(AnnotationElement.Annotation annotation, AnnotationConfiguration annotationConfig) {
        for (AnnotationAttributeConfiguration attributeConfig : annotationConfig.attributes().values()) {
            AnnotationElement.Value value;
            AnnotationElement.Attribute attribute = annotation.getAttributes().get(attributeConfig.name());
            if (attribute != null) {
                value = attribute.getValue();
                if (!attributeConfig.multiple() || value instanceof AnnotationElement.Array) continue;
                value = new AnnotationElement.Array(value.position, Collections.singletonList(value));
                attribute = new AnnotationElement.Attribute(attribute.position, attributeConfig.name(), value);
                annotation.getAttributes().put(attributeConfig.name(), attribute);
                continue;
            }
            if (attributeConfig.defaultValue() != null) {
                AnnotationElement.Value value2 = value = attributeConfig.type() == AnnotationElement.AttributeType.IDENTIFIER ? new AnnotationElement.Identifier(0L, (String)attributeConfig.defaultValue()) : new AnnotationElement.Literal(0L, attributeConfig.defaultValue());
                if (attributeConfig.multiple()) {
                    value = new AnnotationElement.Array(value.position, Collections.singletonList(value));
                }
                attribute = new AnnotationElement.Attribute(0L, attributeConfig.name(), value);
                annotation.getAttributes().put(attributeConfig.name(), attribute);
                continue;
            }
            throw new AnnotationParserException("Attribute '" + attributeConfig.name() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " is required");
        }
    }

    protected abstract AnnotationConfiguration getAnnotationConfig(String var1);

    @Override
    public Map<String, AnnotationElement.Annotation> getAnnotations() throws AnnotationParserException {
        this.processAnnotations();
        return this.annotations;
    }

    @Override
    public <T> T getProcessedAnnotation(String annotationName) throws AnnotationParserException {
        this.processAnnotations();
        return (T)this.processedAnnotations.get(annotationName);
    }
}

