/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationComposeHandler;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.BaseStateTransferInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.AffectedKeysVisitor;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferInterceptor
extends BaseStateTransferInterceptor {
    private static final Log log = LogFactory.getLog(StateTransferInterceptor.class);
    private static boolean trace = log.isTraceEnabled();
    private StateTransferManager stateTransferManager;
    private boolean syncCommitPhase;
    private boolean defaultSynchronous;
    private final AffectedKeysVisitor affectedKeysVisitor = new AffectedKeysVisitor();
    private final InvocationComposeHandler handleReadCommandReturn = this::handleReadCommandReturn;
    private final InvocationComposeHandler handleTxReturn = this::handleTxReturn;
    private final InvocationComposeHandler handleTxWriteReturn = this::handleTxWriteReturn;
    private final InvocationComposeHandler handleNonTxWriteReturn = this::handleNonTxWriteReturn;

    @Inject
    public void init(StateTransferManager stateTransferManager) {
        this.stateTransferManager = stateTransferManager;
    }

    @Start
    public void start() {
        this.syncCommitPhase = this.cacheConfiguration.transaction().syncCommitPhase();
        this.defaultSynchronous = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
    }

    @Override
    public BasicInvocationStage visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    public BasicInvocationStage visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    public BasicInvocationStage visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    private InvocationStage handleReadCommand(InvocationContext ctx, AbstractTopologyAffectedCommand command) throws Throwable {
        if (this.isLocalOnly(command)) {
            return this.invokeNext(ctx, command);
        }
        this.updateTopologyId(command);
        return this.invokeNext(ctx, command).compose(this.handleReadCommandReturn);
    }

    private BasicInvocationStage handleReadCommandReturn(BasicInvocationStage stage, InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) throws Throwable {
        if (t == null) {
            return stage;
        }
        Throwable ce = t;
        while (ce instanceof RemoteException) {
            ce = ce.getCause();
        }
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        int currentTopologyId = cacheTopology == null ? -1 : cacheTopology.getTopologyId();
        AbstractTopologyAffectedCommand cmd = (AbstractTopologyAffectedCommand)rCommand;
        if (ce instanceof SuspectException) {
            if (trace) {
                log.tracef("Retrying command because of suspected node, current topology is %d: %s", currentTopologyId, (Object)rCommand);
            }
            if (currentTopologyId == cmd.getTopologyId() && !cacheTopology.getActualMembers().contains(((SuspectException)ce).getSuspect())) {
                throw new IllegalStateException("Command was not sent with SYNCHRONOUS_IGNORE_LEAVERS?");
            }
        } else if (ce instanceof OutdatedTopologyException) {
            if (trace) {
                log.tracef("Retrying command because of topology change, current topology is %d: %s", currentTopologyId, (Object)cmd);
            }
        } else {
            return stage;
        }
        int newTopologyId = this.getNewTopologyId(ce, currentTopologyId, cmd);
        cmd.setTopologyId(newTopologyId);
        cmd.addFlags(FlagBitSets.COMMAND_RETRY);
        CompletableFuture<Void> topologyFuture = this.stateTransferLock.topologyFuture(newTopologyId);
        return this.retryWhenDone(topologyFuture, newTopologyId, rCtx, cmd).compose(this.handleReadCommandReturn);
    }

    @Override
    public BasicInvocationStage visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    private BasicInvocationStage handleTxCommand(TxInvocationContext ctx, TransactionBoundaryCommand command) throws Throwable {
        if (trace) {
            log.tracef("handleTxCommand for command %s, origin %s", (Object)command, (Object)this.getOrigin(ctx));
        }
        if (this.isLocalOnly(command)) {
            return this.invokeNext(ctx, command);
        }
        this.updateTopologyId(command);
        return this.invokeNext(ctx, command).compose(this.handleTxReturn);
    }

    private Address getOrigin(TxInvocationContext ctx) {
        return ctx.isOriginLocal() ? ctx.getOrigin() : ctx.getGlobalTransaction().getAddress();
    }

    private BasicInvocationStage handleTxReturn(BasicInvocationStage stage, InvocationContext ctx, VisitableCommand command, Object rv, Throwable t) throws Throwable {
        TransactionBoundaryCommand txCommand = (TransactionBoundaryCommand)command;
        int retryTopologyId = -1;
        int currentTopology = this.currentTopologyId();
        if (t instanceof OutdatedTopologyException) {
            retryTopologyId = Math.max(currentTopology, txCommand.getTopologyId() + 1);
        } else if (t != null) {
            return stage;
        }
        boolean async = this.isTxCommandAsync(txCommand);
        if (async) {
            this.stateTransferManager.forwardCommandIfNeeded(txCommand, this.getAffectedKeys(ctx, txCommand), this.getOrigin((TxInvocationContext)ctx));
            return stage;
        }
        if (ctx.isOriginLocal()) {
            if (retryTopologyId > 0) {
                txCommand.setTopologyId(retryTopologyId);
                if (txCommand instanceof PrepareCommand) {
                    ((PrepareCommand)txCommand).setRetriedCommand(true);
                }
                CompletableFuture<Void> transactionDataFuture = this.stateTransferLock.transactionDataFuture(retryTopologyId);
                return this.retryWhenDone(transactionDataFuture, retryTopologyId, ctx, txCommand).compose(this.handleTxReturn);
            }
        } else if (currentTopology > txCommand.getTopologyId()) {
            return this.returnWith(UnsureResponse.INSTANCE);
        }
        return stage;
    }

    private boolean isTxCommandAsync(TransactionBoundaryCommand command) {
        boolean async = false;
        if (command instanceof CommitCommand || command instanceof RollbackCommand) {
            async = !this.syncCommitPhase;
        } else if (command instanceof PrepareCommand) {
            async = !this.defaultSynchronous;
        }
        return async;
    }

    protected BasicInvocationStage handleWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (ctx.isInTxScope()) {
            return this.handleTxWriteCommand(ctx, command);
        }
        return this.handleNonTxWriteCommand(ctx, command);
    }

    private BasicInvocationStage handleTxWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (trace) {
            log.tracef("handleTxWriteCommand for command %s, origin %s", (Object)command, (Object)ctx.getOrigin());
        }
        if (this.isLocalOnly(command)) {
            return this.invokeNext(ctx, command);
        }
        this.updateTopologyId(command);
        return this.invokeNext(ctx, command).compose(this.handleTxWriteReturn);
    }

    private BasicInvocationStage handleTxWriteReturn(BasicInvocationStage stage, InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) throws Throwable {
        int retryTopologyId = -1;
        WriteCommand writeCommand = (WriteCommand)rCommand;
        if (t instanceof OutdatedTopologyException) {
            retryTopologyId = Math.max(this.currentTopologyId(), writeCommand.getTopologyId() + 1);
        } else if (t != null) {
            throw t;
        }
        if (rCtx.isOriginLocal()) {
            if (retryTopologyId > 0) {
                writeCommand.setTopologyId(retryTopologyId);
                CompletableFuture<Void> transactionDataFuture = this.stateTransferLock.transactionDataFuture(retryTopologyId);
                return this.retryWhenDone(transactionDataFuture, retryTopologyId, rCtx, writeCommand).compose(this.handleTxWriteReturn);
            }
        } else if (this.currentTopologyId() > writeCommand.getTopologyId()) {
            return this.returnWith(UnsureResponse.INSTANCE);
        }
        return stage;
    }

    private BasicInvocationStage handleNonTxWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (trace) {
            log.tracef("handleNonTxWriteCommand for command %s, topology id %d", (Object)command, (Object)command.getTopologyId());
        }
        if (this.isLocalOnly(command)) {
            return this.invokeNext(ctx, command);
        }
        this.updateTopologyId(command);
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNext(ctx, command).compose(this.handleNonTxWriteReturn);
    }

    private BasicInvocationStage handleNonTxWriteReturn(BasicInvocationStage stage, InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) throws Throwable {
        if (t == null) {
            return stage;
        }
        Throwable ce = t;
        while (ce instanceof RemoteException) {
            ce = ce.getCause();
        }
        if (!(ce instanceof OutdatedTopologyException) && !(ce instanceof SuspectException)) {
            throw t;
        }
        int currentTopologyId = this.currentTopologyId();
        WriteCommand writeCommand = (WriteCommand)rCommand;
        if (trace) {
            log.tracef("Retrying command because of topology change, current topology is %d: %s", currentTopologyId, (Object)writeCommand);
        }
        int commandTopologyId = writeCommand.getTopologyId();
        int newTopologyId = this.getNewTopologyId(ce, currentTopologyId, writeCommand);
        writeCommand.setTopologyId(newTopologyId);
        writeCommand.addFlags(FlagBitSets.COMMAND_RETRY);
        CompletableFuture<Void> transactionDataFuture = this.stateTransferLock.transactionDataFuture(newTopologyId);
        return this.retryWhenDone(transactionDataFuture, newTopologyId, rCtx, writeCommand).compose(this.handleNonTxWriteReturn);
    }

    private int getNewTopologyId(Throwable ce, int currentTopologyId, TopologyAffectedCommand command) {
        int requestedTopologyId = command.getTopologyId() + 1;
        if (ce instanceof OutdatedTopologyException) {
            OutdatedTopologyException ote = (OutdatedTopologyException)ce;
            if (ote.requestedTopologyId >= 0) {
                requestedTopologyId = ote.requestedTopologyId;
            }
        }
        return Math.max(currentTopologyId, requestedTopologyId);
    }

    @Override
    public BasicInvocationStage handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (command instanceof TopologyAffectedCommand) {
            return this.handleTopologyAffectedCommand(ctx, command, ctx.getOrigin());
        }
        return this.invokeNext(ctx, command);
    }

    private BasicInvocationStage handleTopologyAffectedCommand(InvocationContext ctx, VisitableCommand command, Address origin) throws Throwable {
        if (trace) {
            log.tracef("handleTopologyAffectedCommand for command %s, origin %s", (Object)command, (Object)origin);
        }
        if (this.isLocalOnly(command)) {
            return this.invokeNext(ctx, command);
        }
        this.updateTopologyId((TopologyAffectedCommand)((Object)command));
        return this.invokeNext(ctx, command);
    }

    private boolean isLocalOnly(VisitableCommand command) {
        boolean cacheModeLocal = false;
        if (command instanceof FlagAffectedCommand) {
            cacheModeLocal = ((FlagAffectedCommand)command).hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL);
        }
        return cacheModeLocal;
    }

    private Set<Object> getAffectedKeys(InvocationContext ctx, VisitableCommand command) {
        Set affectedKeys = null;
        try {
            affectedKeys = (Set)command.acceptVisitor(ctx, this.affectedKeysVisitor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (affectedKeys == null) {
            affectedKeys = Collections.emptySet();
        }
        return affectedKeys;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

