/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;

public class StreamMarshalling {
    private StreamMarshalling() {
    }

    public static Predicate<Object> equalityPredicate(Object object) {
        return new EqualityPredicate(object);
    }

    public static Predicate<Object> nonNullPredicate() {
        return NonNullPredicate.getInstance();
    }

    public static Predicate<Object> alwaysTruePredicate() {
        return AlwaysTruePredicate.getInstance();
    }

    public static <K, V> Function<Map.Entry<K, V>, K> entryToKeyFunction() {
        return EntryToKeyFunction.getInstance();
    }

    public static <K, V> Function<Map.Entry<K, V>, V> entryToValueFunction() {
        return EntryToValueFunction.getInstance();
    }

    public static final class StreamMarshallingExternalizer
    implements AdvancedExternalizer<Object> {
        private final Map<Class<? extends Object>, ExternalizerId> objects = new HashMap<Class<? extends Object>, ExternalizerId>();

        public StreamMarshallingExternalizer() {
            for (ExternalizerId id : ExternalizerId.values()) {
                this.objects.put(id.marshalledClass, id);
            }
        }

        @Override
        public Set<Class<?>> getTypeClasses() {
            return Util.asSet(EqualityPredicate.class, EntryToKeyFunction.class, EntryToValueFunction.class, NonNullPredicate.class, AlwaysTruePredicate.class);
        }

        @Override
        public Integer getId() {
            return 86;
        }

        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            ExternalizerId id = this.objects.get(object.getClass());
            if (id == null) {
                throw new IllegalArgumentException("Unsupported class " + object.getClass() + " was provided!");
            }
            output.writeByte(id.ordinal());
            switch (id) {
                case EQUALITY_PREDICATE: {
                    output.writeObject(((EqualityPredicate)object).object);
                }
            }
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int number = input.readUnsignedByte();
            ExternalizerId[] ids = ExternalizerId.values();
            if (number < 0 || number >= ids.length) {
                throw new IllegalArgumentException("Found invalid number " + number);
            }
            ExternalizerId id = ids[number];
            switch (id) {
                case EQUALITY_PREDICATE: {
                    return new EqualityPredicate(input.readObject());
                }
                case ENTRY_KEY_FUNCTION: {
                    return EntryToKeyFunction.getInstance();
                }
                case ENTRY_VALUE_FUNCTION: {
                    return EntryToValueFunction.getInstance();
                }
                case NON_NULL_PREDICATE: {
                    return NonNullPredicate.getInstance();
                }
                case ALWAYS_TRUE_PREDICATE: {
                    return AlwaysTruePredicate.getInstance();
                }
            }
            throw new IllegalArgumentException("ExternalizerId not supported: " + (Object)((Object)id));
        }

        static enum ExternalizerId {
            EQUALITY_PREDICATE(EqualityPredicate.class),
            ENTRY_KEY_FUNCTION(EntryToKeyFunction.class),
            ENTRY_VALUE_FUNCTION(EntryToValueFunction.class),
            NON_NULL_PREDICATE(NonNullPredicate.class),
            ALWAYS_TRUE_PREDICATE(AlwaysTruePredicate.class);

            private final Class<? extends Object> marshalledClass;

            private ExternalizerId(Class<? extends Object> marshalledClass) {
                this.marshalledClass = marshalledClass;
            }
        }
    }

    private static final class EntryToValueFunction<K, V>
    implements Function<Map.Entry<K, V>, V> {
        private static final EntryToValueFunction<?, ?> FUNCTION = new EntryToValueFunction();

        private EntryToValueFunction() {
        }

        public static <K, V> EntryToValueFunction<K, V> getInstance() {
            return FUNCTION;
        }

        @Override
        public V apply(Map.Entry<K, V> kvEntry) {
            return kvEntry.getValue();
        }
    }

    private static final class EntryToKeyFunction<K, V>
    implements Function<Map.Entry<K, V>, K> {
        private static final EntryToKeyFunction<?, ?> FUNCTION = new EntryToKeyFunction();

        private EntryToKeyFunction() {
        }

        public static <K, V> EntryToKeyFunction<K, V> getInstance() {
            return FUNCTION;
        }

        @Override
        public K apply(Map.Entry<K, V> kvEntry) {
            return kvEntry.getKey();
        }
    }

    private static final class AlwaysTruePredicate
    implements Predicate<Object> {
        private static final AlwaysTruePredicate INSTANCE = new AlwaysTruePredicate();

        private AlwaysTruePredicate() {
        }

        public static AlwaysTruePredicate getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean test(Object t) {
            return true;
        }
    }

    private static final class NonNullPredicate
    implements Predicate<Object> {
        private static final NonNullPredicate INSTANCE = new NonNullPredicate();

        private NonNullPredicate() {
        }

        public static NonNullPredicate getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean test(Object t) {
            return t != null;
        }
    }

    private static final class EqualityPredicate
    implements Predicate<Object> {
        private final Object object;

        private EqualityPredicate(Object object) {
            Objects.nonNull(object);
            this.object = object;
        }

        @Override
        public boolean test(Object t) {
            return this.object.equals(t);
        }
    }
}

