/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.executor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public final class Executions {
    private Executions() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static Callable<?> serializableCallable(Constructor<? extends Callable> constructorToUse, Object ... args) throws IllegalArgumentException {
        if (args.length > 127) {
            throw new IllegalArgumentException("Max number of arguments exceeded: 127");
        }
        Class<?>[] params = constructorToUse.getParameterTypes();
        if (params.length != args.length) {
            throw new IllegalArgumentException("Number of arguments [" + args.length + "] doesn't match number of arguments for " + "constructor [" + params.length + "]");
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof Serializable || arg instanceof Streamable) {
                Class<?> classArg = params[i];
                if (classArg.isInstance(arg)) continue;
                throw new IllegalArgumentException("Argument [" + arg + "] is not an instance of [" + classArg + "]");
            }
            throw new IllegalArgumentException("Argument is not serializable, externalizable or streamable: " + arg);
        }
        Class<? extends Callable> classToUse = constructorToUse.getDeclaringClass();
        Constructor<?>[] constructors = classToUse.getConstructors();
        byte constructorPosition = -1;
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            if (!constructor.equals(constructorToUse)) continue;
            if (i > 127) {
                throw new IllegalArgumentException("Constructor position in array cannot be higher than 127");
            }
            constructorPosition = (byte)i;
        }
        if (constructorPosition == -1) {
            throw new IllegalArgumentException("Constructor was not found in public constructor array on class");
        }
        return new StreamableCallable(classToUse, constructorPosition, args);
    }

    protected static class StreamableCallable
    implements Callable<Object>,
    Streamable {
        protected Class<? extends Callable<?>> _classCallable;
        protected short _constructorNumber;
        protected Object[] _args;

        public StreamableCallable() {
        }

        public StreamableCallable(Class<? extends Callable<?>> classCallable, byte constructorNumber, Object ... args) {
            this._classCallable = classCallable;
            this._constructorNumber = constructorNumber;
            this._args = args;
        }

        @Override
        public Object call() throws Exception {
            Constructor<?> constructor = this._classCallable.getConstructors()[this._constructorNumber];
            Callable callable = (Callable)constructor.newInstance(this._args);
            return callable.call();
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeUTF(this._classCallable.getName());
            out.writeByte(this._constructorNumber);
            out.writeByte(this._args.length);
            for (Object arg : this._args) {
                try {
                    Util.writeObject(arg, out);
                }
                catch (Exception e) {
                    throw new IOException("failed to write arg " + arg);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            try {
                String classname = in.readUTF();
                this._classCallable = ClassConfigurator.get(classname);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("failed to read class from classname", e);
            }
            this._constructorNumber = in.readByte();
            int numberOfArgs = in.readByte();
            this._args = new Object[numberOfArgs];
            for (int i = 0; i < numberOfArgs; ++i) {
                try {
                    this._args[i] = Util.readObject(in);
                    continue;
                }
                catch (Exception e) {
                    throw new IOException("failed to read arg", e);
                }
            }
        }

        public String toString() {
            return "StreamableCallable [class=" + this._classCallable + ", constructor=" + this._constructorNumber + ", arguments=" + Arrays.toString(this._args) + "]";
        }
    }
}

