/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public abstract class BaseBundler
implements Bundler {
    protected final Map<Address, List<Message>> msgs = new HashMap<Address, List<Message>>(24);
    protected TP transport;
    protected final ReentrantLock lock = new ReentrantLock();
    protected long count;
    protected ByteArrayDataOutputStream output;
    protected Log log;

    @Override
    public void init(TP transport) {
        this.transport = transport;
        this.log = transport.getLog();
        this.output = new ByteArrayDataOutputStream(transport.getMaxBundleSize() + 3);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void send(Message msg) throws Exception {
    }

    @Override
    public void viewChange(View view) {
        this.lock.lock();
        try {
            this.msgs.keySet().removeIf(mbr -> mbr != null && !view.containsMember((Address)mbr));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.lock.lock();
        try {
            long num = this.msgs.values().stream().flatMap(Collection::stream).map(Message::size).reduce(0L, (a, b) -> a + b);
            int n = (int)num;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void sendBundledMessages() {
        if (this.log.isTraceEnabled()) {
            double percentage = 100.0 / (double)this.transport.getMaxBundleSize() * (double)this.count;
            this.log.trace("%s: sending %d msgs (%d bytes (%.2f%% of max_bundle_size) to %d dests(s): %s", this.transport.localAddress(), this.size(), this.count, percentage, this.msgs.size(), this.msgs.keySet());
        }
        for (Map.Entry<Address, List<Message>> entry : this.msgs.entrySet()) {
            List<Message> list = entry.getValue();
            if (list.isEmpty()) continue;
            this.output.position(0);
            if (list.size() == 1) {
                this.sendSingleMessage(list.get(0));
                continue;
            }
            Address dst = entry.getKey();
            this.sendMessageList(dst, list.get(0).getSrc(), list);
            if (!this.transport.statsEnabled()) continue;
            this.transport.incrBatchesSent(1);
        }
        this.clearMessages();
        this.count = 0L;
    }

    protected void clearMessages() {
        this.msgs.values().stream().filter(list -> list != null).forEach(List::clear);
    }

    protected void sendSingleMessage(Message msg) {
        Address dest = msg.getDest();
        try {
            Util.writeMessage(msg, this.output, dest == null);
            this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
            if (this.transport.statsEnabled()) {
                this.transport.incrNumSingleMsgsSent(1);
            }
        }
        catch (SocketException sock_ex) {
            this.log.trace(Util.getMessage("SendFailure"), this.transport.localAddress(), dest == null ? "cluster" : dest, msg.size(), sock_ex.toString(), msg.printHeaders());
        }
        catch (Throwable e) {
            this.log.error(Util.getMessage("SendFailure"), this.transport.localAddress(), dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }

    protected void sendMessageList(Address dest, Address src, List<Message> list) {
        try {
            Util.writeMessageList(dest, src, this.transport.cluster_name.chars(), list, this.output, dest == null, this.transport.getId());
            this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
        }
        catch (SocketException sock_ex) {
            this.log.debug(Util.getMessage("FailureSendingMsgBundle"), this.transport.localAddress(), sock_ex);
        }
        catch (Throwable e) {
            this.log.error(Util.getMessage("FailureSendingMsgBundle"), this.transport.localAddress(), e);
        }
    }

    protected void addMessage(Message msg, long size) {
        Address dest = msg.getDest();
        List<Message> tmp = this.msgs.get(dest);
        if (tmp == null) {
            tmp = new ArrayList<Message>(5);
            this.msgs.put(dest, tmp);
        }
        tmp.add(msg);
        this.count += size;
    }
}

