/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.group.GroupFilter;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.lifecycle.ComponentStatus;

public class GetKeysInGroupCommand
extends AbstractTopologyAffectedCommand
implements VisitableCommand {
    public static final byte COMMAND_ID = 43;
    private String groupName;
    private transient boolean isGroupOwner;
    private transient GroupManager groupManager;

    public GetKeysInGroupCommand(long flagsBitSet, String groupName) {
        this.groupName = groupName;
        this.setFlagsBitSet(flagsBitSet);
    }

    public GetKeysInGroupCommand() {
    }

    public GetKeysInGroupCommand setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
        return this;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        KeyValueCollector collector = ctx.isOriginLocal() ? new LocalContextKeyValueCollector() : new RemoteContextKeyValueCollector();
        GroupFilter filter = new GroupFilter(this.getGroupName(), this.groupManager);
        for (CacheEntry entry : ctx.getLookedUpEntries().values()) {
            if (entry.isRemoved() || !filter.accept(entry.getKey())) continue;
            collector.addCacheEntry(entry);
        }
        return collector.getResult();
    }

    @Override
    public byte getCommandId() {
        return 43;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.groupName);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.groupName = input.readUTF();
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetKeysInGroupCommand(ctx, this);
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String toString() {
        return "GetKeysInGroupCommand{groupName='" + this.groupName + '\'' + ", flags=" + this.printFlags() + '}';
    }

    public boolean isGroupOwner() {
        return this.isGroupOwner;
    }

    public void setGroupOwner(boolean isGroupOwner) {
        this.isGroupOwner = isGroupOwner;
    }

    private static class RemoteContextKeyValueCollector
    implements KeyValueCollector {
        private final List<CacheEntry> list = new LinkedList<CacheEntry>();

        private RemoteContextKeyValueCollector() {
        }

        @Override
        public void addCacheEntry(CacheEntry entry) {
            this.list.add(entry);
        }

        @Override
        public Object getResult() {
            return this.list;
        }
    }

    private static class LocalContextKeyValueCollector
    implements KeyValueCollector {
        private final Map<Object, Object> map = new HashMap<Object, Object>();

        private LocalContextKeyValueCollector() {
        }

        @Override
        public void addCacheEntry(CacheEntry entry) {
            this.map.put(entry.getKey(), entry.getValue());
        }

        @Override
        public Object getResult() {
            return this.map;
        }
    }

    private static interface KeyValueCollector {
        public void addCacheEntry(CacheEntry var1);

        public Object getResult();
    }
}

