/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.compat;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.Caches;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorMapper;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.compat.TypeConverter;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ForwardingCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.compat.TypeConverterStream;
import org.infinispan.metadata.Metadata;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingEntryCacheSet;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingKeyCacheSet;
import org.infinispan.stream.impl.local.EntryStreamSupplier;
import org.infinispan.stream.impl.local.KeyStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.spliterators.IteratorAsSpliterator;

public abstract class BaseTypeConverterInterceptor<K, V>
extends DDAsyncInterceptor {
    protected InternalEntryFactory entryFactory;
    protected VersionGenerator versionGenerator;
    protected Cache<K, V> cache;

    @Inject
    protected void init(InternalEntryFactory entryFactory, VersionGenerator versionGenerator, Cache<K, V> cache) {
        this.entryFactory = entryFactory;
        this.versionGenerator = versionGenerator;
        this.cache = cache;
    }

    protected abstract TypeConverter<Object, Object, Object, Object> determineTypeConverter(FlagAffectedCommand var1);

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return super.visitPutKeyValueCommand(ctx, command);
        }
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command);
        command.setKey(converter.boxKey(key));
        command.setValue(converter.boxValue(command.getValue()));
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> converter.unboxValue(rv));
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            Map<Object, Object> map = command.getMap();
            TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command);
            HashMap<Object, Object> convertedMap = new HashMap<Object, Object>(map.size());
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                convertedMap.put(converter.boxKey(entry.getKey()), converter.boxValue(entry.getValue()));
            }
            command.setMap(convertedMap);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command);
        command.setKey(converter.boxKey(key));
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (rv == null) {
                return rv;
            }
            return converter.unboxValue(rv);
        });
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command);
        command.setKey(converter.boxKey(key));
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (rv == null) {
                return rv;
            }
            CacheEntry entry = (CacheEntry)rv;
            Object returnValue = converter.unboxValue(entry.getValue());
            return this.entryFactory.create(entry.getKey(), returnValue, entry.getMetadata(), entry.getLifespan(), entry.getMaxIdle());
        });
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        Collection<?> keys = command.getKeys();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command);
        LinkedHashSet<Object> boxedKeys = new LinkedHashSet<Object>(keys.size());
        for (Object key : keys) {
            boxedKeys.add(converter.boxKey(key));
        }
        command.setKeys(boxedKeys);
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (rv == null) {
                return null;
            }
            if (command.isReturnEntries()) {
                Map map = (Map)rv;
                Map unboxed = command.createMap();
                for (Map.Entry entry : map.entrySet()) {
                    CacheEntry cacheEntry = (CacheEntry)entry.getValue();
                    if (cacheEntry == null) {
                        unboxed.put(entry.getKey(), null);
                        continue;
                    }
                    unboxed.put(converter.unboxKey(entry.getKey()), this.entryFactory.create(entry.getKey(), converter.unboxValue(cacheEntry.getValue()), cacheEntry.getMetadata(), cacheEntry.getLifespan(), cacheEntry.getMaxIdle()));
                }
                return unboxed;
            }
            Map map = (Map)rv;
            Map<Object, Object> unboxed = command.createMap();
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                unboxed.put(converter.unboxKey(entry.getKey()), value == null ? null : (Object)converter.unboxValue(value));
            }
            return unboxed;
        });
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return super.visitReplaceCommand(ctx, command);
        }
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command);
        Object oldValue = command.getOldValue();
        command.setKey(converter.boxKey(key));
        command.setOldValue(converter.boxValue(oldValue));
        command.setNewValue(converter.boxValue(command.getNewValue()));
        this.addVersionIfNeeded(command);
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (oldValue != null && rv instanceof Boolean) {
                return rv;
            }
            return converter.unboxValue(rv);
        });
    }

    protected void addVersionIfNeeded(MetadataAwareCommand cmd) {
        Metadata metadata = cmd.getMetadata();
        if (metadata.version() == null) {
            Metadata newMetadata = metadata.builder().version(this.versionGenerator.generateNew()).build();
            cmd.setMetadata(newMetadata);
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return super.visitRemoveCommand(ctx, command);
        }
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command);
        Object conditionalValue = command.getValue();
        command.setKey(converter.boxKey(key));
        command.setValue(converter.boxValue(conditionalValue));
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (conditionalValue != null && rv instanceof Boolean) {
                return rv;
            }
            return ctx.isOriginLocal() ? converter.unboxValue(rv) : rv;
        });
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            KeySetCommand keySetCommand = (KeySetCommand)rCommand;
            CacheSet set = (CacheSet)rv;
            final TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(keySetCommand);
            return new AbstractDelegatingKeyCacheSet<K, V>(Caches.getCacheWithFlags(this.cache, keySetCommand), set){

                @Override
                public CloseableIterator<K> iterator() {
                    return new CloseableIteratorMapper<Object, Object>((CloseableIterator<Object>)super.iterator(), k -> converter.unboxKey(k));
                }

                @Override
                public CloseableSpliterator<K> spliterator() {
                    return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(super.spliterator().estimateSize()).setCharacteristics(4353).get();
                }

                @Override
                protected CacheStream<K> getStream(boolean parallel) {
                    DistributionManager dm = BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getDistributionManager();
                    Spliterator closeableSpliterator = super.spliterator();
                    LocalCacheStream stream = new LocalCacheStream(new KeyStreamSupplier(BaseTypeConverterInterceptor.this.cache, dm != null ? dm.getConsistentHash() : null, () -> 1.lambda$getStream$1((CloseableSpliterator)closeableSpliterator, parallel)), parallel, BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getComponentRegistry());
                    stream.onClose(((CloseableSpliterator)closeableSpliterator)::close);
                    return new TypeConverterStream(stream, converter, BaseTypeConverterInterceptor.this.entryFactory);
                }

                private static /* synthetic */ Stream lambda$getStream$1(CloseableSpliterator closeableSpliterator, boolean parallel) {
                    return StreamSupport.stream(closeableSpliterator, parallel);
                }
            };
        });
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            CacheSet set = (CacheSet)rv;
            EntrySetCommand entrySetCommand = (EntrySetCommand)rCommand;
            final TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(entrySetCommand);
            return new AbstractDelegatingEntryCacheSet<K, V>(Caches.getCacheWithFlags(this.cache, command), set){

                @Override
                public CloseableIterator<CacheEntry<K, V>> iterator() {
                    return new TypeConverterIterator(super.iterator(), converter, BaseTypeConverterInterceptor.this.entryFactory);
                }

                @Override
                public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
                    return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(super.spliterator().estimateSize()).setCharacteristics(4353).get();
                }

                @Override
                protected CacheStream<CacheEntry<K, V>> getStream(boolean parallel) {
                    DistributionManager dm = BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getDistributionManager();
                    Spliterator closeableSpliterator = super.spliterator();
                    LocalCacheStream stream = new LocalCacheStream(new EntryStreamSupplier(BaseTypeConverterInterceptor.this.cache, dm != null ? dm.getConsistentHash() : null, () -> 2.lambda$getStream$0((CloseableSpliterator)closeableSpliterator, parallel)), parallel, BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getComponentRegistry());
                    stream.onClose(((CloseableSpliterator)closeableSpliterator)::close);
                    return new TypeConverterStream(stream, converter, BaseTypeConverterInterceptor.this.entryFactory);
                }

                private static /* synthetic */ Stream lambda$getStream$0(CloseableSpliterator closeableSpliterator, boolean parallel) {
                    return StreamSupport.stream(closeableSpliterator, parallel);
                }
            };
        });
    }

    private static <K, V> CacheEntry<K, V> convert(CacheEntry<K, V> entry, TypeConverter<Object, Object, Object, Object> converter, InternalEntryFactory entryFactory) {
        Object newKey = converter.unboxKey(entry.getKey());
        Object newValue = converter.unboxValue(entry.getValue());
        if (newKey != entry.getKey() || newValue != entry.getValue()) {
            if (entry instanceof InternalCacheEntry) {
                return entryFactory.create(newKey, newValue, (InternalCacheEntry)entry);
            }
            return entryFactory.create(newKey, newValue, entry.getMetadata());
        }
        return entry;
    }

    public static class TypeConverterIterator<K, V>
    implements CloseableIterator<CacheEntry<K, V>> {
        private final CloseableIterator<CacheEntry<K, V>> iterator;
        private final TypeConverter<Object, Object, Object, Object> converter;
        private final InternalEntryFactory entryFactory;

        public TypeConverterIterator(CloseableIterator<CacheEntry<K, V>> iterator, TypeConverter<Object, Object, Object, Object> converter, InternalEntryFactory entryFactory) {
            this.iterator = iterator;
            this.converter = converter;
            this.entryFactory = entryFactory;
        }

        @Override
        public void close() {
            this.iterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public CacheEntry<K, V> next() {
            CacheEntry entry = (CacheEntry)this.iterator.next();
            return new EntryWrapper(entry, BaseTypeConverterInterceptor.convert(entry, this.converter, this.entryFactory));
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class EntryWrapper<K, V>
    extends ForwardingCacheEntry<K, V> {
        private final CacheEntry<K, V> previousEntry;
        private final CacheEntry<K, V> entry;

        public EntryWrapper(CacheEntry<K, V> previousEntry, CacheEntry<K, V> entry) {
            this.previousEntry = previousEntry;
            this.entry = entry;
        }

        @Override
        protected CacheEntry<K, V> delegate() {
            return this.entry;
        }

        @Override
        public V setValue(V value) {
            this.previousEntry.setValue(value);
            return super.setValue(value);
        }
    }
}

