package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Table;
import org.jgroups.util.Util;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla6 {
    protected static final Message         DUMMY_OOB_MSG=new Message().setFlag(Message.Flag.OOB);

    protected static final Predicate<Message> drop_oob_and_dont_loopback_msgs_filter=msg ->
      msg != null && msg != DUMMY_OOB_MSG
        && (!msg.isFlagSet(Message.Flag.OOB) || msg.setTransientFlagIfAbsent(Message.TransientFlag.OOB_DELIVERED))
        && !(msg.isTransientFlagSet(Message.TransientFlag.DONT_LOOPBACK));

    protected static final BiConsumer<MessageBatch,Message> BATCH_ACCUMULATOR=MessageBatch::add;

    public static void main(String[] args) {
        Table<Message> table=new Table<>();

        Address sender=Util.createRandomAddress("B"), local=Util.createRandomAddress("A");

        Message msg=new Message(null, "hello").setFlag(Message.Flag.OOB).src(sender);
        table.add(1, msg);
        System.out.println("table = " + table);

        final MessageBatch batch=new MessageBatch(table.getNumDeliverable())
          .dest(local).sender(sender).multicast(false);
        Supplier<MessageBatch> batch_creator=() -> batch;
        try {
            batch.reset(); // sets index to 0: important as batch delivery may not remove messages from batch!
            table.removeMany(true, 0, drop_oob_and_dont_loopback_msgs_filter,
                             batch_creator, BATCH_ACCUMULATOR);
        }
        catch(Throwable t) {
            System.err.println("failed removing msg: " + t);
        }
        if(!batch.isEmpty()) {
            // batch is guaranteed to NOT contain any OOB messages as the drop_oob_msgs_filter above removed them
            System.err.printf("delivering batch %s: FAIL\n", batch);
        }
        else
            System.out.println("batch is empty: CORRECT");
    }
}
