/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.List;
import org.infinispan.distribution.Ownership;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;

public class DistributionInfo {
    private final Address primary;
    private final List<Address> owners;
    private final Ownership ownership;
    private final int segmentId;

    public DistributionInfo(Object key, ConsistentHash ch, Address self) {
        this.segmentId = ch.getSegment(key);
        this.owners = ch.locateOwnersForSegment(this.segmentId);
        int index = this.owners.indexOf(self);
        if (index == 0) {
            this.ownership = Ownership.PRIMARY;
            this.primary = self;
        } else if (index > 0) {
            this.ownership = Ownership.BACKUP;
            this.primary = this.owners.get(0);
        } else {
            this.ownership = Ownership.NON_OWNER;
            this.primary = this.owners.get(0);
        }
    }

    public int getSegmentId() {
        return this.segmentId;
    }

    public boolean isPrimary() {
        return this.ownership == Ownership.PRIMARY;
    }

    public Address primary() {
        return this.primary;
    }

    public Ownership ownership() {
        return this.ownership;
    }

    public Collection<Address> owners() {
        return this.owners;
    }

    public Collection<Address> backups() {
        return this.owners.subList(1, this.owners.size());
    }
}

