/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.totalorder;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.VersionedDistributionInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderVersionedDistributionInterceptor
extends VersionedDistributionInterceptor {
    private static final Log log = LogFactory.getLog(TotalOrderVersionedDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean onePhaseTotalOrderCommit;

    @Start
    public void start() {
        this.onePhaseTotalOrderCommit = Configurations.isOnePhaseTotalOrderCommit(this.cacheConfiguration);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.onePhaseTotalOrderCommit || !ctx.hasModifications() || !TotalOrderVersionedDistributionInterceptor.shouldTotalOrderRollbackBeInvokedRemotely(ctx)) {
            return this.invokeNext(ctx, command);
        }
        TotalOrderVersionedDistributionInterceptor.totalOrderTxRollback(ctx);
        return super.visitRollbackCommand(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.onePhaseTotalOrderCommit || !ctx.hasModifications()) {
            return this.invokeNext(ctx, command);
        }
        TotalOrderVersionedDistributionInterceptor.totalOrderTxCommit(ctx);
        return super.visitCommitCommand(ctx, command);
    }

    @Override
    protected CompletableFuture<Object> prepareOnAffectedNodes(TxInvocationContext<?> ctx, PrepareCommand command, Collection<Address> recipients) {
        if (trace) {
            log.tracef("Total Order Anycast transaction %s with Total Order", (Object)command.getGlobalTransaction().globalId());
        }
        if (!ctx.hasModifications()) {
            return CompletableFutures.completedNull();
        }
        if (!ctx.isOriginLocal()) {
            throw new IllegalStateException("Expected a local context while TO-Anycast prepare command");
        }
        if (!(command instanceof VersionedPrepareCommand)) {
            throw new IllegalStateException("Expected a Versioned Prepare Command in version aware component");
        }
        return this.totalOrderPrepare(ctx, command, recipients);
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

