/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.inboundhandler.BaseBlockingRunnable;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;

public class DefaultTopologyRunnable
extends BaseBlockingRunnable {
    private final TopologyMode topologyMode;
    private final int commandTopologyId;

    public DefaultTopologyRunnable(BasePerCacheInboundInvocationHandler handler, CacheRpcCommand command, Reply reply, TopologyMode topologyMode, int commandTopologyId, boolean sync) {
        super(handler, command, reply, sync);
        this.topologyMode = topologyMode;
        this.commandTopologyId = commandTopologyId;
    }

    @Override
    public boolean isReady() {
        switch (this.topologyMode) {
            case READY_TOPOLOGY: {
                return this.handler.getStateTransferLock().topologyReceived(this.waitTopology());
            }
            case READY_TX_DATA: {
                return this.handler.getStateTransferLock().transactionDataReceived(this.waitTopology());
            }
        }
        return true;
    }

    @Override
    protected CompletableFuture<Response> beforeInvoke() {
        CompletableFuture<Void> future = null;
        switch (this.topologyMode) {
            case WAIT_TOPOLOGY: {
                future = this.handler.getStateTransferLock().topologyFuture(this.waitTopology());
                break;
            }
            case WAIT_TX_DATA: {
                future = this.handler.getStateTransferLock().transactionDataFuture(this.waitTopology());
                break;
            }
        }
        if (future != null) {
            return future.thenApply(nil -> this.handler.isCommandSentBeforeFirstTopology(this.commandTopologyId) ? CacheNotFoundResponse.INSTANCE : null);
        }
        return this.handler.isCommandSentBeforeFirstTopology(this.commandTopologyId) ? CompletableFuture.completedFuture(CacheNotFoundResponse.INSTANCE) : null;
    }

    private int waitTopology() {
        return Math.max(this.commandTopologyId, 0);
    }
}

