/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.transaction.xa.recovery.RecoverableTransactionIdentifier;

public class RecoveryAwareDldGlobalTransaction
extends DldGlobalTransaction
implements RecoverableTransactionIdentifier {
    private volatile Xid xid;
    private volatile long internalId;

    public RecoveryAwareDldGlobalTransaction() {
    }

    public RecoveryAwareDldGlobalTransaction(Address addr, boolean remote) {
        super(addr, remote);
    }

    @Override
    public Xid getXid() {
        return this.xid;
    }

    @Override
    public void setXid(Xid xid) {
        this.xid = xid;
    }

    @Override
    public long getInternalId() {
        return this.internalId;
    }

    @Override
    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{xid=" + this.xid + ", internalId=" + this.internalId + "} " + super.toString();
    }

    public static class Externalizer
    extends GlobalTransaction.AbstractGlobalTxExternalizer<RecoveryAwareDldGlobalTransaction> {
        @Override
        public void writeObject(ObjectOutput output, RecoveryAwareDldGlobalTransaction globalTransaction) throws IOException {
            super.writeObject(output, globalTransaction);
            output.writeLong(globalTransaction.getCoinToss());
            if (globalTransaction.locksAtOrigin.isEmpty()) {
                output.writeObject(null);
            } else {
                output.writeObject(globalTransaction.locksAtOrigin);
            }
            output.writeObject(globalTransaction.xid);
            output.writeLong(globalTransaction.internalId);
        }

        @Override
        protected RecoveryAwareDldGlobalTransaction createGlobalTransaction() {
            return (RecoveryAwareDldGlobalTransaction)TransactionFactory.TxFactoryEnum.DLD_RECOVERY_XA.newGlobalTransaction();
        }

        @Override
        public RecoveryAwareDldGlobalTransaction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            RecoveryAwareDldGlobalTransaction globalTransaction = (RecoveryAwareDldGlobalTransaction)super.readObject(input);
            globalTransaction.setCoinToss(input.readLong());
            Object locksAtOriginObj = input.readObject();
            if (locksAtOriginObj == null) {
                globalTransaction.setLocksHeldAtOrigin(Collections.emptySet());
            } else {
                globalTransaction.setLocksHeldAtOrigin((Set)locksAtOriginObj);
            }
            Xid xid = (Xid)input.readObject();
            globalTransaction.setXid(xid);
            globalTransaction.setInternalId(input.readLong());
            return globalTransaction;
        }

        @Override
        public Integer getId() {
            return 33;
        }

        @Override
        public Set<Class<? extends RecoveryAwareDldGlobalTransaction>> getTypeClasses() {
            return Util.asSet(RecoveryAwareDldGlobalTransaction.class);
        }
    }
}

