/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.write.BackupWriteRcpCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoveExpiredCommand
extends RemoveCommand {
    public static final int COMMAND_ID = 58;
    private static final Log log = LogFactory.getLog(RemoveExpiredCommand.class);
    private Long lifespan;

    public RemoveExpiredCommand() {
        this.valueMatcher = ValueMatcher.MATCH_EXPECTED_OR_NULL;
    }

    public RemoveExpiredCommand(Object key, Object value, Long lifespan, CacheNotifier notifier, CommandInvocationId commandInvocationId) {
        super(key, value, notifier, 0L, commandInvocationId);
        this.lifespan = lifespan;
        this.valueMatcher = ValueMatcher.MATCH_EXPECTED_OR_NULL;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e != null && !e.isRemoved()) {
            Object value = e.getValue();
            Object prevValue = e.getValue();
            if (this.lifespan == null) {
                if (this.valueMatcher.matches(prevValue, value, null)) {
                    e.setExpired(true);
                    return this.performRemove(e, prevValue, ctx);
                }
            } else if (e.getMetadata() == null) {
                if (value == null || this.valueMatcher.matches(prevValue, value, null)) {
                    e.setExpired(true);
                    return this.performRemove(e, prevValue, ctx);
                }
            } else if (e.getLifespan() > 0L && e.getLifespan() == this.lifespan.longValue()) {
                if (this.valueMatcher.matches(prevValue, value, null)) {
                    e.setExpired(true);
                    return this.performRemove(e, prevValue, ctx);
                }
            } else {
                log.trace("Cannot remove entry as its lifespan or value do not match");
            }
        } else {
            log.trace("Nothing to remove since the entry doesn't exist in the context or it is already removed");
        }
        this.successful = false;
        return false;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public void notify(InvocationContext ctx, Object removedValue, Metadata removedMetadata, boolean isPre) {
        if (!isPre) {
            this.notifier.notifyCacheEntryExpired(this.key, this.value, removedMetadata, ctx);
        }
    }

    @Override
    public byte getCommandId() {
        return 58;
    }

    @Override
    public String toString() {
        return "RemoveExpiredCommand{key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + ", lifespan=" + this.lifespan + '}';
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.key);
        output.writeObject(this.value);
        if (this.lifespan != null) {
            output.writeBoolean(true);
            output.writeLong(this.lifespan);
        } else {
            output.writeBoolean(false);
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.key = input.readObject();
        this.value = input.readObject();
        boolean lifespanProvided = input.readBoolean();
        this.lifespan = lifespanProvided ? Long.valueOf(input.readLong()) : null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveExpiredCommand that = (RemoveExpiredCommand)o;
        return Objects.equals(this.lifespan, that.lifespan);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lifespan);
    }

    @Override
    public long getFlagsBitSet() {
        return FlagBitSets.SKIP_CACHE_LOAD;
    }

    @Override
    public void initBackupWriteRcpCommand(BackupWriteRcpCommand command) {
        command.setRemoveExpired(this.commandInvocationId, this.key, this.value, FlagBitSets.SKIP_CACHE_LOAD, this.getTopologyId());
    }
}

