/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.jgroups.Constructable;
import org.jgroups.blocks.Marshaller;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class MethodCall
implements Streamable,
Constructable<MethodCall> {
    protected short mode;
    protected String method_name;
    protected short method_id;
    protected Object[] args;
    protected Class[] types;
    protected Method method;
    protected static final short METHOD = 1;
    protected static final short TYPES = 2;
    protected static final short ID = 3;

    public MethodCall() {
    }

    public MethodCall(Method method, Object ... arguments) {
        this.init(method);
        if (arguments != null) {
            this.args = arguments;
        }
    }

    public MethodCall(short method_id, Object ... args) {
        this.method_id = method_id;
        this.mode = (short)3;
        this.args = args;
    }

    public MethodCall(String method_name, Object[] args, Class[] types) {
        this.method_name = method_name;
        this.args = args;
        this.types = types;
        this.mode = (short)2;
    }

    @Override
    public Supplier<? extends MethodCall> create() {
        return MethodCall::new;
    }

    public int getMode() {
        return this.mode;
    }

    public int mode() {
        return this.mode;
    }

    public String getMethodName() {
        return this.method_name;
    }

    public String methodName() {
        return this.method_name;
    }

    public MethodCall setMethodName(String n) {
        this.method_name = n;
        return this;
    }

    public MethodCall methodName(String n) {
        this.method_name = n;
        return this;
    }

    public short getMethodId() {
        return this.method_id;
    }

    public short methodId() {
        return this.method_id;
    }

    public MethodCall setMethodId(short id) {
        this.method_id = id;
        return this;
    }

    public MethodCall methodId(short id) {
        this.method_id = id;
        return this;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object[] args() {
        return this.args;
    }

    public MethodCall args(Object ... args) {
        this.args = args;
        return this;
    }

    public MethodCall setArgs(Object ... args) {
        this.args = args;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public Method method() {
        return this.method;
    }

    public MethodCall setMethod(Method m) {
        this.init(m);
        return this;
    }

    public MethodCall method(Method m) {
        this.init(m);
        return this;
    }

    public Object invoke(Object target) throws Exception {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        Class<?> cl = target.getClass();
        Method meth = null;
        switch (this.mode) {
            case 1: {
                if (this.method == null) break;
                meth = this.method;
                break;
            }
            case 2: {
                meth = MethodCall.getMethod(cl, this.method_name, this.types);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("mode " + this.mode + " is invalid");
            }
        }
        if (meth != null) {
            try {
                return meth.invoke(target, this.args);
            }
            catch (InvocationTargetException target_ex) {
                Throwable exception = target_ex.getTargetException();
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof Exception) {
                    throw (Exception)exception;
                }
                throw new RuntimeException(exception);
            }
        }
        throw new NoSuchMethodException(this.method_name);
    }

    public Object invoke(Object target, Object[] args) throws Exception {
        if (args != null) {
            this.args = args;
        }
        return this.invoke(target);
    }

    public static Method findMethod(Class target_class, String method_name, Object[] args) throws Exception {
        int len = args != null ? args.length : 0;
        Method retval = null;
        Method[] methods = MethodCall.getAllMethods(target_class);
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameter_types;
            Method m = methods[i];
            if (!m.getName().equals(method_name) || (parameter_types = m.getParameterTypes()).length != len) continue;
            retval = m;
            boolean all_primitive = true;
            for (Class<?> parameter_type : parameter_types) {
                if (MethodCall.isPrimitiveType(parameter_type)) continue;
                all_primitive = false;
                break;
            }
            if (!all_primitive) continue;
            return m;
        }
        return retval;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        if (this.method_name != null) {
            ret.append(this.method_name);
        } else {
            ret.append(this.method_id);
        }
        ret.append('(');
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    ret.append(", ");
                }
                ret.append(this.args[i]);
            }
        }
        ret.append(')');
        return ret.toString();
    }

    public String toStringDetails() {
        StringBuilder ret = new StringBuilder();
        ret.append("MethodCall ");
        if (this.method_name != null) {
            ret.append("name=").append(this.method_name);
        } else {
            ret.append("id=").append(this.method_id);
        }
        ret.append(", number of args=").append(this.args != null ? this.args.length : 0).append(')');
        if (this.args != null) {
            ret.append("\nArgs:");
            for (int i = 0; i < this.args.length; ++i) {
                ret.append("\n[").append(this.args[i]).append(" (").append(this.args[i] != null ? this.args[i].getClass().getName() : "null").append(")]");
            }
        }
        return ret.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        this.writeTo(out, null);
    }

    public void writeTo(DataOutput out, Marshaller marshaller) throws Exception {
        out.write(this.mode);
        switch (this.mode) {
            case 1: {
                Bits.writeString(this.method_name, out);
                this.writeMethod(out);
                break;
            }
            case 2: {
                Bits.writeString(this.method_name, out);
                this.writeTypes(out);
                break;
            }
            case 3: {
                out.writeShort(this.method_id);
                break;
            }
            default: {
                throw new IllegalStateException("mode " + this.mode + " unknown");
            }
        }
        this.writeArgs(out, marshaller);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.readFrom(in, null);
    }

    public void readFrom(DataInput in, Marshaller marshaller) throws Exception {
        this.mode = in.readByte();
        switch (this.mode) {
            case 1: {
                this.method_name = Bits.readString(in);
                this.readMethod(in);
                break;
            }
            case 2: {
                this.method_name = Bits.readString(in);
                this.readTypes(in);
                break;
            }
            case 3: {
                this.method_id = in.readShort();
                break;
            }
            default: {
                throw new IllegalStateException("mode " + this.mode + " unknown");
            }
        }
        this.readArgs(in, marshaller);
    }

    protected void init(Method method) {
        this.method = method;
        this.mode = 1;
        this.method_name = method.getName();
    }

    protected static Method getMethod(Class target, String methodName, Class[] types) {
        if (types == null) {
            types = new Class[]{};
        }
        Method[] methods = MethodCall.getAllMethods(target);
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameters;
            Method m = methods[i];
            if (!methodName.equals(m.getName()) || types.length != (parameters = m.getParameterTypes()).length) continue;
            for (int j = 0; j < types.length; ++j) {
                if (!parameters[j].isAssignableFrom(types[j])) continue block0;
            }
            return m;
        }
        return null;
    }

    protected void writeArgs(DataOutput out, Marshaller marshaller) throws Exception {
        int args_len = this.args != null ? this.args.length : 0;
        out.write(args_len);
        if (args_len == 0) {
            return;
        }
        for (Object obj : this.args) {
            if (marshaller != null) {
                marshaller.objectToStream(obj, out);
                continue;
            }
            Util.objectToStream(obj, out);
        }
    }

    protected void readArgs(DataInput in, Marshaller marshaller) throws Exception {
        int args_len = in.readByte();
        if (args_len == 0) {
            return;
        }
        this.args = new Object[args_len];
        for (int i = 0; i < args_len; ++i) {
            this.args[i] = marshaller != null ? marshaller.objectFromStream(in) : Util.objectFromStream(in);
        }
    }

    protected void writeTypes(DataOutput out) throws Exception {
        int types_len = this.types != null ? this.types.length : 0;
        out.write(types_len);
        if (types_len > 0) {
            for (Class type : this.types) {
                Util.objectToStream(type, out);
            }
        }
    }

    protected void readTypes(DataInput in) throws Exception {
        int types_len = in.readByte();
        if (types_len > 0) {
            this.types = new Class[types_len];
            for (int i = 0; i < types_len; ++i) {
                this.types[i] = (Class)Util.objectFromStream(in);
            }
        }
    }

    protected void writeMethod(DataOutput out) throws Exception {
        if (this.method != null) {
            out.write(1);
            Util.objectToStream(this.method.getParameterTypes(), out);
            Util.objectToStream(this.method.getDeclaringClass(), out);
        } else {
            out.write(0);
        }
    }

    protected void readMethod(DataInput in) throws Exception {
        if (in.readByte() == 1) {
            Class[] parametertypes = (Class[])Util.objectFromStream(in);
            Class declaringclass = (Class)Util.objectFromStream(in);
            try {
                this.method = declaringclass.getDeclaredMethod(this.method_name, parametertypes);
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e.toString());
            }
        }
    }

    protected static Method[] getAllMethods(Class target) {
        Class superclass = target;
        ArrayList<Method[]> methods = new ArrayList<Method[]>();
        int size = 0;
        while (superclass != null) {
            try {
                Method[] m = superclass.getDeclaredMethods();
                methods.add(m);
                size += m.length;
                superclass = superclass.getSuperclass();
            }
            catch (SecurityException e) {
                superclass = null;
            }
        }
        Method[] result = new Method[size];
        int index = 0;
        for (Method[] m : methods) {
            System.arraycopy(m, 0, result, index, m.length);
            index += m.length;
        }
        return result;
    }

    protected static boolean isPrimitiveType(Class<?> type) {
        return type.isPrimitive() || type == String.class || type == Boolean.class || type == Character.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class;
    }
}

