/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class bla2 {
    protected SecureRandom random;
    protected KeyPair pair;
    protected PrivateKey priv;
    protected PublicKey pub;
    protected static final byte[] message = "hello world from Bela Ban".getBytes();

    protected void start() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA");
        this.random = SecureRandom.getInstance("SHA1PRNG");
        keyGen.initialize(1024, this.random);
        this.pair = keyGen.generateKeyPair();
        this.priv = this.pair.getPrivate();
        this.pub = this.pair.getPublic();
        Signature dsa = Signature.getInstance("SHA1withDSA");
        dsa.initSign(this.priv);
        dsa.update(message);
        byte[] signature = dsa.sign();
        System.out.printf("signature (%d bytes): %s\n", signature.length, Arrays.toString(signature));
        byte[] public_key = this.pub.getEncoded();
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(public_key);
        System.out.println("pubKeySpec = " + pubKeySpec);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
        System.out.println("pubKey = " + pubKey);
        Signature sig = Signature.getInstance("SHA1withDSA");
        sig.initVerify(pubKey);
        sig.update(message);
        boolean verified = sig.verify(signature);
        System.out.println("verified = " + verified);
    }

    public static void main(String[] args) throws Exception {
        new bla2().start();
    }
}

