/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.dmr;

import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import infinispan.org.jboss.dmr.Property;
import infinispan.org.jboss.dmr.ValueExpression;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

abstract class ModelValue
implements Cloneable {
    private final ModelType type;
    static final ModelValue UNDEFINED = new ModelValue(ModelType.UNDEFINED){

        @Override
        String asString() {
            return "undefined";
        }

        @Override
        long asLong(long defVal) {
            return defVal;
        }

        @Override
        int asInt(int defVal) {
            return defVal;
        }

        @Override
        boolean asBoolean(boolean defVal) {
            return defVal;
        }

        @Override
        double asDouble(double defVal) {
            return defVal;
        }

        @Override
        public boolean equals(Object other) {
            return other == this;
        }

        @Override
        void formatAsJSON(PrintWriter writer, int indent, boolean multiLine) {
            writer.append("null");
        }

        @Override
        void writeExternal(DataOutput out) throws IOException {
            out.write(ModelType.UNDEFINED.typeChar);
        }

        @Override
        public int hashCode() {
            return 7113;
        }
    };

    protected ModelValue(ModelType type) {
        this.type = type;
    }

    ModelType getType() {
        return this.type;
    }

    long asLong() {
        throw new IllegalArgumentException();
    }

    long asLong(long defVal) {
        throw new IllegalArgumentException();
    }

    int asInt() {
        throw new IllegalArgumentException();
    }

    int asInt(int defVal) {
        throw new IllegalArgumentException();
    }

    boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    boolean asBoolean(boolean defVal) {
        throw new IllegalArgumentException();
    }

    double asDouble() {
        throw new IllegalArgumentException();
    }

    double asDouble(double defVal) {
        throw new IllegalArgumentException();
    }

    byte[] asBytes() {
        throw new IllegalArgumentException();
    }

    BigDecimal asBigDecimal() {
        throw new IllegalArgumentException();
    }

    BigInteger asBigInteger() {
        throw new IllegalArgumentException();
    }

    abstract String asString();

    Property asProperty() {
        throw new IllegalArgumentException();
    }

    List<Property> asPropertyList() {
        throw new IllegalArgumentException();
    }

    ValueExpression asExpression() {
        throw new IllegalArgumentException();
    }

    ModelNode asObject() {
        throw new IllegalArgumentException();
    }

    ModelNode getChild(String name) {
        throw new IllegalArgumentException();
    }

    ModelNode removeChild(String name) {
        throw new IllegalArgumentException();
    }

    ModelNode removeChild(int index) {
        throw new IllegalArgumentException();
    }

    ModelNode getChild(int index) {
        throw new IllegalArgumentException();
    }

    ModelNode addChild() {
        throw new IllegalArgumentException();
    }

    ModelNode insertChild(int index) {
        throw new IllegalArgumentException();
    }

    Set<String> getKeys() {
        throw new IllegalArgumentException();
    }

    List<ModelNode> asList() {
        throw new IllegalArgumentException();
    }

    ModelType asType() {
        throw new IllegalArgumentException();
    }

    ModelValue protect() {
        return this;
    }

    protected final ModelValue clone() {
        try {
            return (ModelValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String quote(String orig) {
        int length = orig.length();
        StringBuilder builder = new StringBuilder(length + 32);
        builder.append('\"');
        int i = 0;
        while (i < length) {
            int cp = orig.codePointAt(i);
            if (cp == 34 || cp == 92) {
                builder.append('\\').appendCodePoint(cp);
            } else {
                builder.appendCodePoint(cp);
            }
            i = orig.offsetByCodePoints(i, 1);
        }
        builder.append('\"');
        return builder.toString();
    }

    protected static String jsonEscape(String orig) {
        int length = orig.length();
        StringBuilder builder = new StringBuilder(length + 32);
        builder.append('\"');
        int i = 0;
        while (i < length) {
            int cp = orig.codePointAt(i);
            switch (cp) {
                case 34: {
                    builder.append("\\\"");
                    break;
                }
                case 92: {
                    builder.append("\\\\");
                    break;
                }
                case 8: {
                    builder.append("\\b");
                    break;
                }
                case 12: {
                    builder.append("\\f");
                    break;
                }
                case 10: {
                    builder.append("\\n");
                    break;
                }
                case 13: {
                    builder.append("\\r");
                    break;
                }
                case 9: {
                    builder.append("\\t");
                    break;
                }
                default: {
                    if (cp < 32) {
                        String hexString = Integer.toHexString(cp);
                        builder.append("\\u");
                        for (int k = 0; k < 4 - hexString.length(); ++k) {
                            builder.append('0');
                        }
                        builder.append(hexString.toUpperCase());
                        break;
                    }
                    builder.appendCodePoint(cp);
                }
            }
            i = orig.offsetByCodePoints(i, 1);
        }
        builder.append('\"');
        return builder.toString();
    }

    ModelValue copy() {
        return this;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected static void indent(PrintWriter writer, int count) {
        for (int i = 0; i < count; ++i) {
            writer.append("    ");
        }
    }

    void format(PrintWriter writer, int indent, boolean multiLine) {
        writer.append(this.asString());
    }

    void formatAsJSON(PrintWriter writer, int indent, boolean multiLine) {
        writer.append(this.asString());
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter, true);
        this.writeString(writer, false);
        return stringWriter.toString();
    }

    public void writeString(PrintWriter writer, boolean compact) {
        this.format(writer, 0, !compact);
    }

    public String toJSONString(boolean compact) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter, true);
        this.writeJSONString(writer, compact);
        return stringWriter.toString();
    }

    public void writeJSONString(PrintWriter writer, boolean compact) {
        this.formatAsJSON(writer, 0, !compact);
    }

    ModelValue resolve() {
        return this.copy();
    }

    abstract void writeExternal(DataOutput var1) throws IOException;

    boolean has(int index) {
        return false;
    }

    boolean has(String key) {
        return false;
    }

    ModelNode requireChild(String name) throws NoSuchElementException {
        throw new NoSuchElementException("No child '" + name + "' exists");
    }

    ModelNode requireChild(int index) throws NoSuchElementException {
        throw new NoSuchElementException("No child exists at index [" + index + "]");
    }
}

