/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.Bits;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.UnsafeWrapper;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.TimeService;

public class OffHeapEntryFactoryImpl
implements OffHeapEntryFactory {
    private static final UnsafeWrapper UNSAFE = UnsafeWrapper.INSTANCE;
    private Marshaller marshaller;
    private OffHeapMemoryAllocator allocator;
    private TimeService timeService;
    private InternalEntryFactory internalEntryFactory;
    private boolean evictionEnabled;
    private static final byte CUSTOM = 1;
    private static final byte HAS_VERSION = 2;
    private static final byte IMMORTAL = 4;
    private static final byte MORTAL = 8;
    private static final byte TRANSIENT = 16;
    private static final byte TRANSIENT_MORTAL = 32;
    private static final int BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final int HEADER_LENGTH = 17;

    @Inject
    public void inject(Marshaller marshaller, OffHeapMemoryAllocator allocator, TimeService timeService, InternalEntryFactory internalEntryFactory, Configuration configuration) {
        this.marshaller = marshaller;
        this.allocator = allocator;
        this.timeService = timeService;
        this.internalEntryFactory = internalEntryFactory;
        this.evictionEnabled = configuration.memory().size() > 0L;
    }

    @Override
    public long create(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        long memoryOffset;
        long memoryAddress;
        byte[] metadataBytes;
        int type;
        if (metadata instanceof EmbeddedMetadata) {
            byte[] versionBytes;
            EntryVersion version = metadata.version();
            if (version != null) {
                type = 2;
                try {
                    versionBytes = this.marshaller.objectToByteBuffer(version);
                }
                catch (IOException | InterruptedException e) {
                    throw new CacheException(e);
                }
            } else {
                type = 0;
                versionBytes = new byte[]{};
            }
            long lifespan = metadata.lifespan();
            long maxIdle = metadata.maxIdle();
            if (lifespan < 0L && maxIdle < 0L) {
                type = (byte)(type | 4);
                metadataBytes = versionBytes;
            } else if (lifespan > -1L && maxIdle < 0L) {
                type = (byte)(type | 8);
                metadataBytes = new byte[16 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, lifespan);
                Bits.putLong(metadataBytes, 8, this.timeService.wallClockTime());
                System.arraycopy(metadataBytes, 0, versionBytes, 16, versionBytes.length);
            } else if (lifespan < 0L && maxIdle > -1L) {
                type = (byte)(type | 0x10);
                metadataBytes = new byte[16 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, maxIdle);
                Bits.putLong(metadataBytes, 8, this.timeService.wallClockTime());
                System.arraycopy(metadataBytes, 0, versionBytes, 16, versionBytes.length);
            } else {
                type = (byte)(type | 0x20);
                metadataBytes = new byte[32 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, maxIdle);
                Bits.putLong(metadataBytes, 8, lifespan);
                Bits.putLong(metadataBytes, 16, this.timeService.wallClockTime());
                Bits.putLong(metadataBytes, 24, this.timeService.wallClockTime());
                System.arraycopy(metadataBytes, 0, versionBytes, 16, versionBytes.length);
            }
        } else {
            type = 1;
            try {
                metadataBytes = this.marshaller.objectToByteBuffer(metadata);
            }
            catch (IOException | InterruptedException e) {
                throw new CacheException(e);
            }
        }
        int keySize = key.getLength();
        int valueSize = value.getLength();
        int metadataSize = metadataBytes.length;
        long totalSize = 25 + keySize + metadataSize + valueSize;
        if (this.evictionEnabled) {
            memoryAddress = this.allocator.allocate(totalSize + 8L);
            memoryOffset = memoryAddress + 8L;
        } else {
            memoryOffset = memoryAddress = this.allocator.allocate(totalSize);
        }
        int offset = 0;
        byte[] header = new byte[17];
        Bits.putInt(header, offset, key.hashCode());
        Bits.putInt(header, offset += 4, key.getLength());
        Bits.putInt(header, offset += 4, metadataBytes.length);
        Bits.putInt(header, offset += 4, value.getLength());
        offset += 4;
        header[offset++] = type;
        UNSAFE.putLong(memoryOffset, 0L);
        UNSAFE.copyMemory(header, BYTE_ARRAY_BASE_OFFSET, null, memoryOffset += 8L, 17L);
        UNSAFE.copyMemory(key.getBytes(), key.backArrayOffset() + BYTE_ARRAY_BASE_OFFSET, null, memoryOffset += 17L, keySize);
        UNSAFE.copyMemory(metadataBytes, BYTE_ARRAY_BASE_OFFSET, null, memoryOffset += (long)keySize, metadataSize);
        UNSAFE.copyMemory(value.getBytes(), value.backArrayOffset() + BYTE_ARRAY_BASE_OFFSET, null, memoryOffset += (long)metadataSize, valueSize);
        return memoryAddress;
    }

    @Override
    public long determineSize(long address) {
        int beginningOffset = this.evictionEnabled ? 16 : 8;
        byte[] header = this.readHeader((long)beginningOffset + address);
        int keyLength = Bits.getInt(header, 4);
        int metadataLength = Bits.getInt(header, 8);
        int valueLength = Bits.getInt(header, 12);
        return beginningOffset + 17 + keyLength + metadataLength + valueLength;
    }

    @Override
    public long getNextLinkedPointerAddress(long address) {
        return UNSAFE.getLong(this.evictionEnabled ? address + 8L : address);
    }

    @Override
    public void updateNextLinkedPointerAddress(long address, long value) {
        UNSAFE.putLong(this.evictionEnabled ? address + 8L : address, value);
    }

    @Override
    public int getHashCodeForAddress(long address) {
        byte[] header = this.readHeader(this.evictionEnabled ? address + 16L : address + 8L);
        return Bits.getInt(header, 0);
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> fromMemory(long address) {
        long lastUsed;
        long created;
        long maxIdle;
        long lifespan;
        byte[] header = this.readHeader(address += (long)(this.evictionEnabled ? 16 : 8));
        int offset = 0;
        int hashCode = Bits.getInt(header, offset);
        byte[] keyBytes = new byte[Bits.getInt(header, offset += 4)];
        byte[] metadataBytes = new byte[Bits.getInt(header, offset += 4)];
        byte[] valueBytes = new byte[Bits.getInt(header, offset += 4)];
        offset += 4;
        byte metadataType = header[offset++];
        long memoryOffset = address + (long)offset;
        UNSAFE.copyMemory(null, memoryOffset, keyBytes, BYTE_ARRAY_BASE_OFFSET, keyBytes.length);
        UNSAFE.copyMemory(null, memoryOffset += (long)keyBytes.length, metadataBytes, BYTE_ARRAY_BASE_OFFSET, metadataBytes.length);
        UNSAFE.copyMemory(null, memoryOffset += (long)metadataBytes.length, valueBytes, BYTE_ARRAY_BASE_OFFSET, valueBytes.length);
        memoryOffset += (long)valueBytes.length;
        if ((metadataType & 1) == 1) {
            Metadata metadata;
            try {
                metadata = (Metadata)this.marshaller.objectFromByteBuffer(metadataBytes);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException(e);
            }
            return this.internalEntryFactory.create(new WrappedByteArray(keyBytes), new WrappedByteArray(valueBytes), metadata);
        }
        offset = 0;
        boolean hasVersion = (metadataType & 2) == 2;
        switch (metadataType & 0xFC) {
            case 4: {
                lifespan = -1L;
                maxIdle = -1L;
                created = -1L;
                lastUsed = -1L;
                break;
            }
            case 8: {
                maxIdle = -1L;
                lifespan = Bits.getLong(metadataBytes, offset++);
                created = Bits.getLong(metadataBytes, offset += 8);
                lastUsed = -1L;
                break;
            }
            case 16: {
                lifespan = -1L;
                maxIdle = Bits.getLong(metadataBytes, offset++);
                created = -1L;
                lastUsed = Bits.getLong(metadataBytes, offset += 8);
                break;
            }
            case 32: {
                lifespan = Bits.getLong(metadataBytes, offset++);
                maxIdle = Bits.getLong(metadataBytes, offset += 8);
                created = Bits.getLong(metadataBytes, offset += 8);
                lastUsed = Bits.getLong(metadataBytes, offset += 8);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + metadataType);
            }
        }
        if (hasVersion) {
            try {
                EntryVersion version = (EntryVersion)this.marshaller.objectFromByteBuffer(metadataBytes, offset, metadataBytes.length - offset);
                return this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), new WrappedByteArray(valueBytes), version, created, lifespan, lastUsed, maxIdle);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException(e);
            }
        }
        return this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), new WrappedByteArray(valueBytes), (Metadata)null, created, lifespan, lastUsed, maxIdle);
    }

    @Override
    public WrappedBytes getKey(long address) {
        byte[] header = this.readHeader(address += (long)(this.evictionEnabled ? 16 : 8));
        int keyLength = Bits.getInt(header, 4);
        byte[] keyBytes = new byte[keyLength];
        UNSAFE.copyMemory(null, address + 17L, keyBytes, BYTE_ARRAY_BASE_OFFSET, keyBytes.length);
        return new WrappedByteArray(keyBytes);
    }

    private byte[] readHeader(long address) {
        byte[] header = new byte[17];
        UNSAFE.copyMemory(null, address, header, BYTE_ARRAY_BASE_OFFSET, header.length);
        return header;
    }

    @Override
    public boolean equalsKey(long address, WrappedBytes wrappedBytes) {
        byte[] header = this.readHeader(address += this.evictionEnabled ? 16L : 8L);
        int hashCode = wrappedBytes.hashCode();
        if (hashCode != Bits.getInt(header, 0)) {
            return false;
        }
        int keyLength = Bits.getInt(header, 4);
        byte[] keyBytes = new byte[keyLength];
        UNSAFE.copyMemory(null, address + 17L, keyBytes, BYTE_ARRAY_BASE_OFFSET, keyLength);
        return new WrappedByteArray(keyBytes, hashCode).equalsWrappedBytes(wrappedBytes);
    }
}

