/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class PutAllOperation
extends RetryOnFailureOperation<Void> {
    protected final Map<byte[], byte[]> map;
    protected final long lifespan;
    private final TimeUnit lifespanTimeUnit;
    protected final long maxIdle;
    private final TimeUnit maxIdleTimeUnit;

    public PutAllOperation(Codec codec, TransportFactory transportFactory, Map<byte[], byte[]> map, byte[] cacheName, AtomicInteger topologyId, int flags, ClientIntelligence clientIntelligence, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        super(codec, transportFactory, cacheName, topologyId, flags, clientIntelligence);
        this.map = map;
        this.lifespan = lifespan;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdle = maxIdle;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
    }

    @Override
    protected Void executeOperation(Transport transport) {
        HeaderParams params = this.writeHeader(transport, (short)45);
        this.codec.writeExpirationParams(transport, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        transport.writeVInt(this.map.size());
        for (Map.Entry<byte[], byte[]> entry : this.map.entrySet()) {
            transport.writeArray(entry.getKey());
            transport.writeArray(entry.getValue());
        }
        transport.flush();
        short status = this.readHeaderAndValidate(transport, params);
        if (!HotRodConstants.isSuccess(status)) {
            throw new InvalidResponseException("Unexpected response status: " + Integer.toHexString(status));
        }
        return null;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(this.map.keySet().iterator().next(), failedServers, this.cacheName);
    }
}

