/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commons.api.functional.EntryView;

final class Mutations {
    private Mutations() {
    }

    static <K, V, R> void writeTo(ObjectOutput output, Mutation<K, V, R> mutation) throws IOException {
        byte type = mutation.type();
        output.writeByte(type);
        switch (type) {
            case 0: {
                output.writeObject(((ReadWrite)mutation).f);
                break;
            }
            case 1: {
                output.writeObject(((ReadWriteWithValue)mutation).value);
                output.writeObject(((ReadWriteWithValue)mutation).f);
                break;
            }
            case 2: {
                output.writeObject(((Write)mutation).f);
                break;
            }
            case 3: {
                output.writeObject(((WriteWithValue)mutation).value);
                output.writeObject(((WriteWithValue)mutation).f);
            }
        }
    }

    static <K, V> Mutation<K, V, ?> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        switch (input.readByte()) {
            case 0: {
                return new ReadWrite((Function)input.readObject());
            }
            case 1: {
                return new ReadWriteWithValue(input.readObject(), (BiFunction)input.readObject());
            }
            case 2: {
                return new Write((Consumer)input.readObject());
            }
            case 3: {
                return new WriteWithValue(input.readObject(), (BiConsumer)input.readObject());
            }
        }
        throw new IllegalStateException("Unknown type of mutation, broken input?");
    }

    static class WriteWithValue<K, V>
    implements Mutation<K, V, Void> {
        static final byte TYPE = 3;
        private final V value;
        private final BiConsumer<V, EntryView.WriteEntryView<V>> f;

        public WriteWithValue(V value, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
            this.value = value;
            this.f = f;
        }

        @Override
        public byte type() {
            return 3;
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<K, V> view) {
            this.f.accept(this.value, view);
            return null;
        }
    }

    static class Write<K, V>
    implements Mutation<K, V, Void> {
        static final byte TYPE = 2;
        private final Consumer<EntryView.WriteEntryView<V>> f;

        public Write(Consumer<EntryView.WriteEntryView<V>> f) {
            this.f = f;
        }

        @Override
        public byte type() {
            return 2;
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<K, V> view) {
            this.f.accept(view);
            return null;
        }
    }

    static class ReadWriteWithValue<K, V, R>
    implements Mutation<K, V, R> {
        static final byte TYPE = 1;
        private final V value;
        private final BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f;

        public ReadWriteWithValue(V value, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f) {
            this.value = value;
            this.f = f;
        }

        @Override
        public byte type() {
            return 1;
        }

        @Override
        public R apply(EntryView.ReadWriteEntryView<K, V> view) {
            return this.f.apply(this.value, view);
        }
    }

    static class ReadWrite<K, V, R>
    implements Mutation<K, V, R> {
        static final byte TYPE = 0;
        private final Function<EntryView.ReadWriteEntryView<K, V>, R> f;

        public ReadWrite(Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
            this.f = f;
        }

        @Override
        public byte type() {
            return 0;
        }

        @Override
        public R apply(EntryView.ReadWriteEntryView<K, V> view) {
            return this.f.apply(view);
        }
    }
}

