/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.WriteResponse;

public class TriangleResponseGenerator
implements ResponseGenerator {
    private static DataWriteCommand extractCommandOrNull(CacheRpcCommand cacheRpcCommand) {
        if (cacheRpcCommand instanceof SingleRpcCommand) {
            ReplicableCommand command = ((SingleRpcCommand)cacheRpcCommand).getCommand();
            return command instanceof PutKeyValueCommand || command instanceof RemoveCommand || command instanceof ReplaceCommand ? (DataWriteCommand)command : null;
        }
        return null;
    }

    private static boolean isReturnValueExpected(DataWriteCommand dataWriteCommand) {
        return dataWriteCommand.isConditional() || dataWriteCommand.isReturnValueExpected();
    }

    @Override
    public Response getResponse(CacheRpcCommand command, Object returnValue) {
        if (returnValue instanceof Response) {
            return (Response)returnValue;
        }
        DataWriteCommand dataWriteCommand = TriangleResponseGenerator.extractCommandOrNull(command);
        if (dataWriteCommand != null) {
            return new WriteResponse(TriangleResponseGenerator.isReturnValueExpected(dataWriteCommand) ? returnValue : null, dataWriteCommand.isSuccessful());
        }
        if (command.isReturnValueExpected()) {
            return SuccessfulResponse.create(returnValue);
        }
        return null;
    }
}

