/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.ping.common.Utils;
import org.jgroups.ping.common.server.Server;
import org.jgroups.ping.common.server.ServerFactory;
import org.jgroups.ping.common.server.Servers;
import org.jgroups.protocols.PING;
import org.openshift.ping.common.compatibility.CompatibilityException;
import org.openshift.ping.common.compatibility.CompatibilityUtils;

public abstract class OpenshiftPing
extends PING {
    private String clusterName;
    private final String _systemEnvPrefix;
    @Property
    private int connectTimeout = 5000;
    private int _connectTimeout;
    @Property
    private int readTimeout = 30000;
    private int _readTimeout;
    @Property
    private int operationAttempts = 3;
    private int _operationAttempts;
    @Property
    private long operationSleep = 1000L;
    private long _operationSleep;
    private ServerFactory _serverFactory;
    private Server _server;
    private String _serverName;
    private static Method sendMethod;

    public OpenshiftPing(String systemEnvPrefix) {
        this._systemEnvPrefix = Utils.trimToNull(systemEnvPrefix);
        try {
            sendMethod = CompatibilityUtils.isJGroups4() ? this.getClass().getMethod("up", Message.class) : this.getClass().getMethod("up", Event.class);
        }
        catch (Exception e) {
            throw new CompatibilityException("Could not find suitable 'up' method.", e);
        }
    }

    protected final String getSystemEnvName(String systemEnvSuffix) {
        StringBuilder sb = new StringBuilder();
        String suffix = Utils.trimToNull(systemEnvSuffix);
        if (suffix != null) {
            if (this._systemEnvPrefix != null) {
                sb.append(this._systemEnvPrefix);
            }
            sb.append(suffix);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    protected final int getConnectTimeout() {
        return this._connectTimeout;
    }

    protected final int getReadTimeout() {
        return this._readTimeout;
    }

    protected final int getOperationAttempts() {
        return this._operationAttempts;
    }

    protected final long getOperationSleep() {
        return this._operationSleep;
    }

    protected abstract boolean isClusteringEnabled();

    protected abstract int getServerPort();

    public final void setServerFactory(ServerFactory serverFactory) {
        this._serverFactory = serverFactory;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this._connectTimeout = Utils.getSystemEnvInt(this.getSystemEnvName("CONNECT_TIMEOUT"), this.connectTimeout);
        this._readTimeout = Utils.getSystemEnvInt(this.getSystemEnvName("READ_TIMEOUT"), this.readTimeout);
        this._operationAttempts = Utils.getSystemEnvInt(this.getSystemEnvName("OPERATION_ATTEMPTS"), this.operationAttempts);
        this._operationSleep = Utils.getSystemEnvInt(this.getSystemEnvName("OPERATION_SLEEP"), (int)this.operationSleep);
    }

    @Override
    public void destroy() {
        this._connectTimeout = 0;
        this._readTimeout = 0;
        this._operationAttempts = 0;
        this._operationSleep = 0L;
        super.destroy();
    }

    @Override
    public void start() throws Exception {
        if (this.isClusteringEnabled()) {
            int serverPort = this.getServerPort();
            this._server = this._serverFactory != null ? this._serverFactory.getServer(serverPort) : Servers.getServer(serverPort);
            this._serverName = this._server.getClass().getSimpleName();
            if (this.log.isInfoEnabled()) {
                this.log.info(String.format("Starting %s on port %s for channel address: %s", this._serverName, serverPort, this.stack.getChannel().getAddress()));
            }
            boolean started = this._server.start(this.stack.getChannel());
            if (this.log.isInfoEnabled()) {
                this.log.info(String.format("%s %s.", this._serverName, started ? "started" : "reused (pre-existing)"));
            }
        }
        super.start();
    }

    @Override
    public void stop() {
        try {
            if (this._server != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info(String.format("Stopping server: %s", this._serverName));
                }
                boolean stopped = this._server.stop(this.stack.getChannel());
                if (this.log.isInfoEnabled()) {
                    this.log.info(String.format("%s %s.", this._serverName, stopped ? "stopped" : "not stopped (still in use)"));
                }
            }
        }
        finally {
            super.stop();
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.clusterName = (String)evt.getArg();
            }
        }
        return super.down(evt);
    }

    @Override
    protected void sendMcastDiscoveryRequest(Message msg) {
        List<InetSocketAddress> nodes = this.readAll();
        if (nodes == null) {
            return;
        }
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        for (InetSocketAddress node : nodes) {
            this.timer.execute(new SendDiscoveryRequest(node, msg));
        }
    }

    public void handlePingRequest(InputStream stream) throws Exception {
        DataInputStream dataInput = new DataInputStream(stream);
        Message msg = new Message();
        msg.readFrom(dataInput);
        try {
            this.sendUp(msg);
        }
        catch (Exception e) {
            this.log.error("Error processing GET_MBRS_REQ.", e);
        }
    }

    private void sendUp(Message msg) {
        try {
            if (CompatibilityUtils.isJGroups4()) {
                sendMethod.invoke((Object)this, msg);
            } else {
                sendMethod.invoke((Object)this, new Event(1, msg));
            }
        }
        catch (Exception e) {
            throw new CompatibilityException("Could not invoke 'up' method.", e);
        }
    }

    private List<InetSocketAddress> readAll() {
        if (this.isClusteringEnabled()) {
            return this.doReadAll(this.clusterName);
        }
        return Collections.emptyList();
    }

    protected abstract List<InetSocketAddress> doReadAll(String var1);

    private final class SendDiscoveryRequest
    implements Runnable {
        private final InetSocketAddress node;
        private final Message msg;
        private int attempts;

        private SendDiscoveryRequest(InetSocketAddress node, Message msg) {
            this.node = node;
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ++this.attempts;
            String url = String.format("http://%s:%s", this.node.getHostString(), this.node.getPort());
            if (OpenshiftPing.this.log.isTraceEnabled()) {
                OpenshiftPing.this.log.trace(String.format("%s opening connection: url [%s], clusterName [%s], connectTimeout [%s], readTimeout [%s]", this.getClass().getSimpleName(), url, OpenshiftPing.this.clusterName, OpenshiftPing.this._connectTimeout, OpenshiftPing.this._readTimeout));
            }
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)new URL(url).openConnection();
                connection.addRequestProperty("CLUSTER_NAME", OpenshiftPing.this.clusterName);
                if (OpenshiftPing.this._connectTimeout < 0 || OpenshiftPing.this._readTimeout < 0) {
                    throw new IllegalArgumentException(String.format("Neither connectTimeout [%s] nor readTimeout [%s] can be less than 0 for URLConnection.", OpenshiftPing.this._connectTimeout, OpenshiftPing.this._readTimeout));
                }
                connection.setConnectTimeout(OpenshiftPing.this._connectTimeout);
                connection.setReadTimeout(OpenshiftPing.this._readTimeout);
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                this.msg.writeTo(out);
                out.flush();
                String responseMessage = connection.getResponseMessage();
                if (OpenshiftPing.this.log.isTraceEnabled()) {
                    OpenshiftPing.this.log.trace(String.format("%s received response from server: url [%s], clusterName [%s], response [%s]", this.getClass().getSimpleName(), url, OpenshiftPing.this.clusterName, responseMessage));
                }
            }
            catch (Exception e) {
                OpenshiftPing.this.log.warn(String.format("Error sending ping request: url [%s], clusterName [%s], attempts[%d]: %s", url, OpenshiftPing.this.clusterName, this.attempts, e.getLocalizedMessage()));
                if (this.attempts < OpenshiftPing.this._operationAttempts) {
                    OpenshiftPing.this.timer.schedule(this, OpenshiftPing.this._operationSleep, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }
}

