/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetKeysOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.ExecuteOperation;
import org.infinispan.client.hotrod.impl.operations.FaultTolerantPingOperation;
import org.infinispan.client.hotrod.impl.operations.GetAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetStreamOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithVersionOperation;
import org.infinispan.client.hotrod.impl.operations.IterationEndOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.PutAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.PutStreamOperation;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.SizeOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class OperationsFactory
implements HotRodConstants {
    private final ThreadLocal<Integer> flagsMap = new ThreadLocal();
    private final TransportFactory transportFactory;
    private final byte[] cacheNameBytes;
    private final AtomicInteger topologyId;
    private final boolean forceReturnValue;
    private final Codec codec;
    private final ClientListenerNotifier listenerNotifier;
    private final String cacheName;
    private final ExecutorService executorService;
    private final ClientIntelligence clientIntelligence;

    public OperationsFactory(TransportFactory transportFactory, String cacheName, boolean forceReturnValue, Codec codec, ClientListenerNotifier listenerNotifier, ExecutorService executorService, ClientIntelligence clientIntelligence) {
        this.transportFactory = transportFactory;
        this.executorService = executorService;
        this.cacheNameBytes = cacheName == null ? null : RemoteCacheManager.cacheNameBytes(cacheName);
        this.cacheName = cacheName;
        this.topologyId = transportFactory != null ? transportFactory.createTopologyId(this.cacheNameBytes) : new AtomicInteger(-1);
        this.forceReturnValue = forceReturnValue;
        this.codec = codec;
        this.listenerNotifier = listenerNotifier;
        this.clientIntelligence = clientIntelligence;
    }

    public OperationsFactory(TransportFactory transportFactory, Codec codec, ExecutorService executorService, ClientIntelligence clientIntelligence) {
        this(transportFactory, null, false, codec, null, executorService, clientIntelligence);
    }

    public ClientListenerNotifier getListenerNotifier() {
        return this.listenerNotifier;
    }

    public byte[] getCacheName() {
        return this.cacheNameBytes;
    }

    public <V> GetOperation<V> newGetKeyOperation(Object key, byte[] keyBytes) {
        return new GetOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public <K, V> GetAllParallelOperation<K, V> newGetAllOperation(Set<byte[]> keys) {
        return new GetAllParallelOperation(this.codec, this.transportFactory, keys, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, this.executorService);
    }

    public <V> RemoveOperation<V> newRemoveOperation(Object key, byte[] keyBytes) {
        return new RemoveOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public <V> RemoveIfUnmodifiedOperation<V> newRemoveIfUnmodifiedOperation(Object key, byte[] keyBytes, long version) {
        return new RemoveIfUnmodifiedOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, version);
    }

    public ReplaceIfUnmodifiedOperation newReplaceIfUnmodifiedOperation(Object key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, long version) {
        return new ReplaceIfUnmodifiedOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), this.clientIntelligence, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, version);
    }

    public <V> GetWithVersionOperation<V> newGetWithVersionOperation(Object key, byte[] keyBytes) {
        return new GetWithVersionOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public <V> GetWithMetadataOperation<V> newGetWithMetadataOperation(Object key, byte[] keyBytes) {
        return new GetWithMetadataOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public StatsOperation newStatsOperation() {
        return new StatsOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public <V> PutOperation<V> newPutKeyValueOperation(Object key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return new PutOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), this.clientIntelligence, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
    }

    public PutAllParallelOperation newPutAllOperation(Map<byte[], byte[]> map, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return new PutAllParallelOperation(this.codec, this.transportFactory, map, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), this.clientIntelligence, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, this.executorService);
    }

    public <V> PutIfAbsentOperation<V> newPutIfAbsentOperation(Object key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new PutIfAbsentOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdleTime), this.clientIntelligence, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public <V> ReplaceOperation<V> newReplaceOperation(Object key, byte[] keyBytes, byte[] values, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return new ReplaceOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), this.clientIntelligence, values, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
    }

    public ContainsKeyOperation newContainsKeyOperation(Object key, byte[] keyBytes) {
        return new ContainsKeyOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public ClearOperation newClearOperation() {
        return new ClearOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public <K, V> BulkGetOperation<K, V> newBulkGetOperation(int size) {
        return new BulkGetOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, size);
    }

    public <K> BulkGetKeysOperation<K> newBulkGetKeysOperation(int scope) {
        return new BulkGetKeysOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, scope);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener) {
        return new AddClientListenerOperation(this.codec, this.transportFactory, this.cacheName, this.topologyId, this.flags(), this.clientIntelligence, this.listenerNotifier, listener, null, null);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        return new AddClientListenerOperation(this.codec, this.transportFactory, this.cacheName, this.topologyId, this.flags(), this.clientIntelligence, this.listenerNotifier, listener, filterFactoryParams, converterFactoryParams);
    }

    public RemoveClientListenerOperation newRemoveClientListenerOperation(Object listener) {
        return new RemoveClientListenerOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, this.listenerNotifier, listener);
    }

    public PingOperation newPingOperation(Transport transport) {
        return new PingOperation(this.codec, this.topologyId, this.clientIntelligence, transport, this.cacheNameBytes);
    }

    public FaultTolerantPingOperation newFaultTolerantPingOperation() {
        return new FaultTolerantPingOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public QueryOperation newQueryOperation(RemoteQuery remoteQuery) {
        return new QueryOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, remoteQuery);
    }

    public SizeOperation newSizeOperation() {
        return new SizeOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public <T> ExecuteOperation<T> newExecuteOperation(String taskName, Map<String, byte[]> marshalledParams) {
        return new ExecuteOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, taskName, marshalledParams);
    }

    private int flags(long lifespan, long maxIdle) {
        int intFlags = this.flags();
        if (lifespan == 0L) {
            intFlags |= Flag.DEFAULT_LIFESPAN.getFlagInt();
        }
        if (maxIdle == 0L) {
            intFlags |= Flag.DEFAULT_MAXIDLE.getFlagInt();
        }
        return intFlags;
    }

    public int flags() {
        Integer threadLocalFlags = this.flagsMap.get();
        this.flagsMap.remove();
        int intFlags = 0;
        if (threadLocalFlags != null) {
            intFlags |= threadLocalFlags.intValue();
        }
        if (this.forceReturnValue) {
            intFlags |= Flag.FORCE_RETURN_VALUE.getFlagInt();
        }
        return intFlags;
    }

    public void setFlags(Flag[] flags) {
        int intFlags = 0;
        for (Flag flag : flags) {
            intFlags |= flag.getFlagInt();
        }
        this.flagsMap.set(intFlags);
    }

    public void setFlags(int intFlags) {
        this.flagsMap.set(intFlags);
    }

    public boolean hasFlag(Flag flag) {
        Integer threadLocalFlags = this.flagsMap.get();
        return threadLocalFlags != null && (threadLocalFlags & flag.getFlagInt()) != 0;
    }

    public CacheTopologyInfo getCacheTopologyInfo() {
        return this.transportFactory.getCacheTopologyInfo(this.cacheNameBytes);
    }

    public IterationStartOperation newIterationStartOperation(String filterConverterFactory, byte[][] filterParameters, Set<Integer> segments, int batchSize, boolean metadata) {
        return new IterationStartOperation(this.codec, this.flags(), this.clientIntelligence, this.cacheNameBytes, this.topologyId, filterConverterFactory, filterParameters, segments, batchSize, this.transportFactory, metadata);
    }

    public IterationEndOperation newIterationEndOperation(String iterationId, Transport transport) {
        return new IterationEndOperation(this.codec, this.flags(), this.clientIntelligence, this.cacheNameBytes, this.topologyId, iterationId, this.transportFactory, transport);
    }

    public <K, V> IterationNextOperation newIterationNextOperation(String iterationId, Transport transport, KeyTracker segmentKeyTracker) {
        return new IterationNextOperation(this.codec, this.flags(), this.clientIntelligence, this.cacheNameBytes, this.topologyId, iterationId, transport, segmentKeyTracker);
    }

    public <K> GetStreamOperation newGetStreamOperation(K key, byte[] keyBytes, int offset) {
        return new GetStreamOperation(this.codec, this.transportFactory, key, keyBytes, offset, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence);
    }

    public <K> PutStreamOperation newPutStreamOperation(K key, byte[] keyBytes, long version, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new PutStreamOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, version, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public <K> PutStreamOperation newPutStreamOperation(K key, byte[] keyBytes, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new PutStreamOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, 0L, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public <K> PutStreamOperation newPutIfAbsentStreamOperation(K key, byte[] keyBytes, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new PutStreamOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.clientIntelligence, -1L, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }
}

