/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.HealthStatus;
import org.infinispan.health.impl.CacheHealthImpl;
import org.infinispan.manager.EmbeddedCacheManager;

public class ClusterHealthImpl
implements ClusterHealth {
    private final EmbeddedCacheManager cacheManager;

    public ClusterHealthImpl(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public HealthStatus getHealthStatus() {
        Set healthStatuses = this.cacheManager.getCacheNames().stream().map(cacheName -> this.cacheManager.getCache((String)cacheName)).map(cache -> new CacheHealthImpl((Cache<?, ?>)cache)).map(cacheHealth -> cacheHealth.getStatus()).collect(Collectors.toSet());
        if (healthStatuses.contains((Object)HealthStatus.UNHEALTHY)) {
            return HealthStatus.UNHEALTHY;
        }
        if (healthStatuses.contains((Object)HealthStatus.REBALANCING)) {
            return HealthStatus.REBALANCING;
        }
        return HealthStatus.HEALTHY;
    }

    @Override
    public String getClusterName() {
        return this.cacheManager.getClusterName();
    }

    @Override
    public int getNumberOfNodes() {
        return Optional.ofNullable(this.cacheManager.getTransport()).map(t -> t.getMembers().size()).orElse(1);
    }

    @Override
    public List<String> getNodeNames() {
        return Optional.ofNullable(this.cacheManager.getTransport()).map(t -> t.getMembers()).orElse(Collections.emptyList()).stream().map(member -> member.toString()).collect(Collectors.toList());
    }
}

