/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.manager.ClusterExecutionPolicy;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.LocalClusterExecutor;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.jgroups.util.Rsp;

abstract class AbstractClusterExecutor<T extends ClusterExecutor>
extends LocalClusterExecutor {
    protected final JGroupsTransport transport;
    protected final Address me;

    AbstractClusterExecutor(Predicate<? super Address> predicate, EmbeddedCacheManager manager, JGroupsTransport transport, long time, TimeUnit unit, Executor localExecutor, ScheduledExecutorService timeoutExecutor) {
        super(predicate, manager, localExecutor, time, unit, timeoutExecutor);
        this.transport = transport;
        this.me = Objects.requireNonNull(transport.getAddress(), "Transport was not started before retrieving a ClusterExecutor!");
    }

    protected abstract T sameClusterExecutor(Predicate<? super Address> var1, long var2, TimeUnit var4);

    protected abstract Log getLog();

    @Override
    Address getMyAddress() {
        return this.me;
    }

    static org.jgroups.Address convertToJGroupsAddress(Address address) {
        return ((JGroupsAddress)address).getJGroupsAddress();
    }

    void consumeResponse(Rsp<Response> resp, org.jgroups.Address target, Consumer<? super Throwable> throwableEater) {
        this.consumeResponse(resp, target, o -> {}, throwableEater, throwableEater);
    }

    void consumeResponse(Rsp<Response> resp, org.jgroups.Address target, Consumer<Object> resultsEater, Consumer<? super Throwable> throwableEater, Consumer<? super TimeoutException> timeoutEater) {
        if (resp.wasReceived()) {
            Response ispnResponse;
            if (resp.hasException()) {
                throwableEater.accept(resp.getException());
            }
            if ((ispnResponse = resp.getValue()) != null) {
                if (ispnResponse instanceof ExceptionResponse) {
                    throwableEater.accept(((ExceptionResponse)ispnResponse).getException().getCause());
                } else if (ispnResponse instanceof SuccessfulResponse) {
                    resultsEater.accept(((SuccessfulResponse)ispnResponse).getResponseValue());
                } else {
                    throwableEater.accept(new IllegalStateException("Response was neither successful or an exception!"));
                }
            } else {
                resultsEater.accept(null);
            }
        } else if (resp.wasSuspected()) {
            throwableEater.accept(this.getLog().remoteNodeSuspected(JGroupsAddressCache.fromJGroupsAddress(target)));
        } else {
            timeoutEater.accept(this.getLog().remoteNodeTimedOut(JGroupsAddressCache.fromJGroupsAddress(target), this.time, this.unit));
        }
    }

    List<org.jgroups.Address> getJGroupsTargets(boolean includeMe) {
        List<org.jgroups.Address> list;
        List<Address> ispnMembers = this.transport.getMembers();
        int size = ispnMembers.size();
        if (size == 0) {
            list = Collections.emptyList();
        } else if (this.predicate == null) {
            if (size == 1) {
                Address member = ispnMembers.get(0);
                list = !includeMe && member.equals(this.me) ? Collections.emptyList() : Collections.singletonList(AbstractClusterExecutor.convertToJGroupsAddress(member));
            } else {
                list = (includeMe ? ispnMembers.stream() : ispnMembers.stream().filter(a -> !a.equals(this.me))).map(AbstractClusterExecutor::convertToJGroupsAddress).collect(Collectors.toList());
            }
        } else {
            list = (includeMe ? ispnMembers.stream() : ispnMembers.stream().filter(a -> !a.equals(this.me))).filter(this.predicate).map(AbstractClusterExecutor::convertToJGroupsAddress).collect(Collectors.toList());
        }
        return list;
    }

    public T filterTargets(Predicate<? super Address> predicate) {
        return this.sameClusterExecutor(predicate, this.time, this.unit);
    }

    public T filterTargets(ClusterExecutionPolicy policy) throws IllegalStateException {
        if (!this.manager.getCacheManagerConfiguration().transport().hasTopologyInfo()) {
            throw new IllegalStateException("Topology information is not available!");
        }
        return this.sameClusterExecutor(a -> policy.include((TopologyAwareAddress)this.me, (TopologyAwareAddress)a), this.time, this.unit);
    }

    public T filterTargets(ClusterExecutionPolicy policy, Predicate<? super Address> predicate) throws IllegalStateException {
        if (!this.manager.getCacheManagerConfiguration().transport().hasTopologyInfo()) {
            throw new IllegalStateException();
        }
        return this.sameClusterExecutor(a -> policy.include((TopologyAwareAddress)this.me, (TopologyAwareAddress)a) && predicate.test((Address)a), this.time, this.unit);
    }

    public T filterTargets(Collection<Address> addresses) {
        return this.filterTargets(addresses::contains);
    }

    public T noFilter() {
        if (this.predicate == null) {
            return (T)this;
        }
        return this.sameClusterExecutor(null, this.time, this.unit);
    }

    public T timeout(long time, TimeUnit unit) {
        if (time <= 0L) {
            throw new IllegalArgumentException("Time must be greater than 0!");
        }
        Objects.requireNonNull(unit, "TimeUnit must be non null!");
        if (this.time == time && this.unit == unit) {
            return (T)this;
        }
        return this.sameClusterExecutor(this.predicate, time, unit);
    }
}

