/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.transport.AbstractTransport;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.remoting.transport.jgroups.JGroupsBackupResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.infinispan.remoting.transport.jgroups.JGroupsResponseFilterAdapter;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.Responses;
import org.infinispan.remoting.transport.jgroups.SingleResponseFuture;
import org.infinispan.remoting.transport.jgroups.SiteMasterPickerImpl;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.remoting.transport.jgroups.ThreadPoolProbeHandler;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.jgroups.AnycastAddress;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.RouteStatusListener;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.tom.TOA;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.Rsp;

public class JGroupsTransport
extends AbstractTransport
implements MembershipListener {
    public static final String CONFIGURATION_STRING = "configurationString";
    public static final String CONFIGURATION_XML = "configurationXml";
    public static final String CONFIGURATION_FILE = "configurationFile";
    public static final String CHANNEL_LOOKUP = "channelLookup";
    protected static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "default-configs/default-jgroups-udp.xml";
    private static final Log log = LogFactory.getLog(JGroupsTransport.class);
    private static final boolean trace = log.isTraceEnabled();
    protected boolean connectChannel = true;
    protected boolean disconnectChannel = true;
    protected boolean closeChannel = true;
    protected CommandAwareRpcDispatcher dispatcher;
    protected TypedProperties props;
    protected StreamingMarshaller marshaller;
    protected CacheManagerNotifier notifier;
    protected TimeService timeService;
    protected InboundInvocationHandler globalHandler;
    protected ScheduledExecutorService timeoutExecutor;
    protected Executor remoteExecutor;
    private boolean globalStatsEnabled;
    private MBeanServer mbeanServer;
    private String domain;
    protected JChannel channel;
    protected Address address;
    protected Address physicalAddress;
    protected volatile int viewId = -1;
    protected volatile List<Address> members = null;
    protected volatile Address coordinator = null;
    protected volatile boolean isCoordinator = false;
    private final Lock viewUpdateLock = new ReentrantLock();
    private final Condition viewUpdateCondition = this.viewUpdateLock.newCondition();
    private CompletableFuture<Void> nextViewFuture = new CompletableFuture();
    private final ThreadPoolProbeHandler handler;

    public JGroupsTransport(JChannel channel) {
        this.channel = channel;
        if (channel == null) {
            throw new IllegalArgumentException("Cannot deal with a null channel!");
        }
        if (channel.isConnected()) {
            throw new IllegalArgumentException("Channel passed in cannot already be connected!");
        }
        this.handler = new ThreadPoolProbeHandler();
    }

    public JGroupsTransport() {
        this.handler = new ThreadPoolProbeHandler();
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Inject
    public void initialize(StreamingMarshaller marshaller, CacheManagerNotifier notifier, TimeService timeService, InboundInvocationHandler globalHandler, @ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService timeoutExecutor, @ComponentName(value="org.infinispan.executors.remote") ExecutorService remoteExecutor) {
        this.marshaller = marshaller;
        this.notifier = notifier;
        this.timeService = timeService;
        this.globalHandler = globalHandler;
        this.timeoutExecutor = timeoutExecutor;
        this.remoteExecutor = remoteExecutor;
        this.handler.updateThreadPool(remoteExecutor);
    }

    @Override
    public void start() {
        this.props = TypedProperties.toTypedProperties(this.configuration.transport().properties());
        if (log.isInfoEnabled()) {
            log.startingJGroupsChannel(this.configuration.transport().clusterName());
        }
        this.initChannelAndRPCDispatcher();
        this.addXSiteViewListener();
        this.addSiteMasterPicker();
        this.startJGroupsChannelIfNeeded();
        this.waitForInitialNodes();
        this.channel.getProtocolStack().getTransport().registerProbeHandler(this.handler);
    }

    protected void startJGroupsChannelIfNeeded() {
        String clusterName = this.configuration.transport().clusterName();
        if (this.connectChannel) {
            try {
                this.channel.connect(clusterName);
            }
            catch (Exception e) {
                throw new CacheException("Unable to start JGroups Channel", e);
            }
            try {
                this.globalStatsEnabled = this.configuration.globalJmxStatistics().enabled();
                if (this.globalStatsEnabled) {
                    String groupName = String.format("type=channel,cluster=%s", ObjectName.quote(clusterName));
                    this.mbeanServer = JmxUtil.lookupMBeanServer(this.configuration);
                    this.domain = JmxUtil.buildJmxDomain(this.configuration, this.mbeanServer, groupName);
                    JmxConfigurator.registerChannel(this.channel, this.mbeanServer, this.domain, clusterName, true);
                }
            }
            catch (Exception e) {
                throw new CacheException("Channel connected, but unable to register MBeans", e);
            }
        }
        this.address = JGroupsTransport.fromJGroupsAddress(this.channel.getAddress());
        if (!this.connectChannel) {
            this.viewAccepted(this.channel.getView());
        }
        if (log.isInfoEnabled()) {
            log.localAndPhysicalAddress(clusterName, this.getAddress(), this.getPhysicalAddresses());
        }
    }

    @Override
    public int getViewId() {
        if (this.channel == null) {
            throw new CacheException("The cache has been stopped and invocations are not allowed!");
        }
        return this.viewId;
    }

    @Override
    public CompletableFuture<Void> withView(int expectedViewId) {
        if (this.viewId >= expectedViewId) {
            return CompletableFutures.completedNull();
        }
        if (trace) {
            log.tracef("Waiting for transaction data for view %d, current view is %d", expectedViewId, this.viewId);
        }
        this.viewUpdateLock.lock();
        try {
            if (this.viewId >= expectedViewId) {
                CompletableFuture<Void> completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            if (this.viewId < 0) {
                throw new IllegalLifecycleStateException();
            }
            CompletionStage completionStage = this.nextViewFuture.thenCompose(nil -> this.withView(expectedViewId));
            return completionStage;
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForView(int viewId) throws InterruptedException {
        if (this.channel == null) {
            return;
        }
        log.tracef("Waiting on view %d being accepted", viewId);
        long remainingNanos = Long.MAX_VALUE;
        this.viewUpdateLock.lock();
        try {
            while (this.channel != null && this.getViewId() < viewId && remainingNanos > 0L) {
                remainingNanos = this.viewUpdateCondition.awaitNanos(remainingNanos);
            }
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    @Override
    public void stop() {
        if (this.channel != null) {
            this.channel.getProtocolStack().getTransport().unregisterProbeHandler(this.handler);
        }
        String clusterName = this.configuration.transport().clusterName();
        try {
            if (this.disconnectChannel && this.channel != null && this.channel.isConnected()) {
                log.disconnectJGroups(clusterName);
                if (this.globalStatsEnabled) {
                    JmxConfigurator.unregisterChannel(this.channel, this.mbeanServer, this.domain, this.channel.getClusterName());
                }
                this.channel.disconnect();
            }
            if (this.closeChannel && this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (Exception toLog) {
            log.problemClosingChannel(toLog, clusterName);
        }
        if (this.dispatcher != null) {
            log.stoppingRpcDispatcher(clusterName);
            this.dispatcher.close();
            if (this.channel != null) {
                UpHandler handler = this.channel.getUpHandler();
                log.debugf("Removing existing UpHandler %s", (Object)handler);
                this.channel.setUpHandler(null);
            }
        }
        this.channel = null;
        this.viewId = -1;
        this.members = Collections.emptyList();
        this.coordinator = null;
        this.isCoordinator = false;
        this.dispatcher = null;
        CompletableFuture<Void> oldFuture = null;
        this.viewUpdateLock.lock();
        try {
            oldFuture = this.nextViewFuture;
            this.nextViewFuture = new CompletableFuture();
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
            if (oldFuture != null) {
                oldFuture.complete(null);
            }
        }
    }

    protected void initChannel() {
        TransportConfiguration transportCfg = this.configuration.transport();
        if (this.channel == null) {
            String transportNodeName;
            this.buildChannel();
            if (this.connectChannel && (transportNodeName = transportCfg.nodeName()) != null && transportNodeName.length() > 0) {
                long range = 65534L;
                long randomInRange = (long)(Math.random() * (double)range % (double)range) + 1L;
                transportNodeName = transportNodeName + "-" + randomInRange;
                this.channel.setName(transportNodeName);
            }
        }
        this.channel.setDiscardOwnMessages(false);
        if (transportCfg.hasTopologyInfo()) {
            if (this.connectChannel) {
                this.channel.addAddressGenerator(() -> JGroupsTopologyAwareAddress.randomUUID(this.channel.getName(), transportCfg.siteId(), transportCfg.rackId(), transportCfg.machineId()));
            } else {
                org.jgroups.Address jgroupsAddress = this.channel.getAddress();
                if (jgroupsAddress instanceof ExtendedUUID) {
                    JGroupsTopologyAwareAddress address = new JGroupsTopologyAwareAddress((ExtendedUUID)jgroupsAddress);
                    if (!address.matches(transportCfg.siteId(), transportCfg.rackId(), transportCfg.machineId())) {
                        throw new CacheException("Topology information does not match the one set by the provided JGroups channel");
                    }
                } else {
                    throw new CacheException("JGroups address does not contain topology coordinates");
                }
            }
        }
    }

    private void initChannelAndRPCDispatcher() throws CacheException {
        this.initChannel();
        this.initRPCDispatcher();
    }

    protected void initRPCDispatcher() {
        this.dispatcher = new CommandAwareRpcDispatcher(this.channel, this, this.globalHandler, this.timeoutExecutor, this.timeService, this.remoteExecutor, this.marshaller);
        this.dispatcher.start();
    }

    private void buildChannel() {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        if (this.props != null) {
            String cfg;
            if (this.props.containsKey(CHANNEL_LOOKUP)) {
                String channelLookupClassName = this.props.getProperty(CHANNEL_LOOKUP);
                try {
                    JGroupsChannelLookup lookup = (JGroupsChannelLookup)Util.getInstance(channelLookupClassName, this.configuration.classLoader());
                    this.channel = lookup.getJGroupsChannel(this.props);
                    this.connectChannel = lookup.shouldConnect();
                    this.disconnectChannel = lookup.shouldDisconnect();
                    this.closeChannel = lookup.shouldClose();
                }
                catch (ClassCastException e) {
                    log.wrongTypeForJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException(e);
                }
                catch (Exception e) {
                    log.errorInstantiatingJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException(e);
                }
            }
            if (this.channel == null && this.props.containsKey(CONFIGURATION_FILE)) {
                cfg = this.props.getProperty(CONFIGURATION_FILE);
                Collection<Object> confs = Collections.emptyList();
                try {
                    confs = fileLookup.lookupFileLocations(cfg, this.configuration.classLoader());
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (confs.isEmpty()) {
                    throw log.jgroupsConfigurationNotFound(cfg);
                }
                if (confs.size() > 1) {
                    log.ambiguousConfigurationFiles(Util.toStr(confs));
                }
                try {
                    this.channel = new JChannel((URL)confs.iterator().next());
                }
                catch (Exception e) {
                    throw log.errorCreatingChannelFromConfigFile(cfg, e);
                }
            }
            if (this.channel == null && this.props.containsKey(CONFIGURATION_XML)) {
                cfg = this.props.getProperty(CONFIGURATION_XML);
                try {
                    this.channel = new JChannel(XmlConfigHelper.stringToElement(cfg));
                }
                catch (Exception e) {
                    throw log.errorCreatingChannelFromXML(cfg, e);
                }
            }
            if (this.channel == null && this.props.containsKey(CONFIGURATION_STRING)) {
                cfg = this.props.getProperty(CONFIGURATION_STRING);
                try {
                    this.channel = new JChannel(new ByteArrayInputStream(cfg.getBytes()));
                }
                catch (Exception e) {
                    throw log.errorCreatingChannelFromConfigString(cfg, e);
                }
            }
        }
        if (this.channel == null) {
            log.unableToUseJGroupsPropertiesProvided(this.props);
            try {
                this.channel = new JChannel(fileLookup.lookupFileLocation(DEFAULT_JGROUPS_CONFIGURATION_FILE, this.configuration.classLoader()));
            }
            catch (Exception e) {
                throw log.errorCreatingChannelFromConfigFile(DEFAULT_JGROUPS_CONFIGURATION_FILE, e);
            }
        }
    }

    @Override
    public boolean isCoordinator() {
        return this.isCoordinator;
    }

    @Override
    public Address getCoordinator() {
        return this.coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInitialNodes() {
        int initialClusterSize = this.configuration.transport().initialClusterSize();
        if (initialClusterSize <= 1) {
            return;
        }
        long timeout = this.configuration.transport().initialClusterTimeout();
        long remainingNanos = TimeUnit.MILLISECONDS.toNanos(timeout);
        this.viewUpdateLock.lock();
        try {
            while (this.channel != null && this.channel.getView().getMembers().size() < initialClusterSize && remainingNanos > 0L) {
                log.debugf("Waiting for %d nodes, current view has %d", initialClusterSize, this.channel.getView().getMembers().size());
                remainingNanos = this.viewUpdateCondition.awaitNanos(remainingNanos);
            }
        }
        catch (InterruptedException e) {
            log.interruptedWaitingForCoordinator(e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.viewUpdateLock.unlock();
        }
        if (remainingNanos <= 0L) {
            throw log.timeoutWaitingForInitialNodes(initialClusterSize, this.channel.getView().getMembers());
        }
        log.debugf("Initial cluster size of %d nodes reached", initialClusterSize);
    }

    @Override
    public List<Address> getMembers() {
        return this.members != null ? this.members : Collections.emptyList();
    }

    @Override
    public boolean isMulticastCapable() {
        return this.channel.getProtocolStack().getTransport().supportsMulticasting();
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public List<Address> getPhysicalAddresses() {
        if (this.physicalAddress == null && this.channel != null) {
            org.jgroups.Address addr = (org.jgroups.Address)this.channel.down(new Event(87, this.channel.getAddress()));
            if (addr == null) {
                return Collections.emptyList();
            }
            this.physicalAddress = new JGroupsAddress(addr);
        }
        return Collections.singletonList(this.physicalAddress);
    }

    @Override
    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, org.infinispan.remoting.rpc.ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        CompletableFuture<Map<Address, Response>> future = this.invokeRemotelyAsync(recipients, rpcCommand, mode, timeout, responseFilter, deliverOrder, anycast);
        try {
            return CompletableFutures.await(future);
        }
        catch (ExecutionException e) {
            throw Util.rewrapAsCacheException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpcCommand, org.infinispan.remoting.rpc.ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        boolean totalOrder;
        if (recipients != null && recipients.isEmpty()) {
            log.trace("Destination list is empty: no need to send message");
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        boolean bl = totalOrder = deliverOrder == DeliverOrder.TOTAL;
        if (trace) {
            log.tracef("dests=%s, command=%s, mode=%s, timeout=%s", new Object[]{recipients, rpcCommand, mode, timeout});
        }
        Address self = this.getAddress();
        boolean ignoreLeavers = mode == org.infinispan.remoting.rpc.ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS || mode == org.infinispan.remoting.rpc.ResponseMode.WAIT_FOR_VALID_RESPONSE;
        List<Address> members = this.getMembers();
        if (mode.isSynchronous() && recipients != null && !members.containsAll(recipients) && !ignoreLeavers) {
            Address suspect = recipients.stream().filter(a -> !members.contains(a)).findFirst().orElse(null);
            CompletableFuture<Map<Address, Response>> future = new CompletableFuture<Map<Address, Response>>();
            future.completeExceptionally(new SuspectException("One or more nodes have left the cluster while replicating command " + rpcCommand, suspect));
            return future;
        }
        List<org.jgroups.Address> jgAddressList = this.toJGroupsAddressListExcludingSelf(recipients, totalOrder);
        if (jgAddressList != null && jgAddressList.isEmpty()) {
            return CompletableFutures.completedEmptyMap();
        }
        List<Address> localMembers = this.members;
        int membersSize = localMembers.size();
        boolean broadcast = membersSize > 2 && (jgAddressList == null || recipients.size() == membersSize);
        CompletableFuture<Responses> rspListFuture = null;
        SingleResponseFuture singleResponseFuture = null;
        org.jgroups.Address singleJGAddress = null;
        if (broadcast) {
            rspListFuture = this.dispatcher.invokeRemoteCommands(null, rpcCommand, JGroupsTransport.toJGroupsMode(mode), timeout, this.toJGroupsFilter(responseFilter), deliverOrder);
        } else if (totalOrder) {
            rspListFuture = this.dispatcher.invokeRemoteCommands(jgAddressList, rpcCommand, JGroupsTransport.toJGroupsMode(mode), timeout, this.toJGroupsFilter(responseFilter), deliverOrder);
        } else {
            boolean singleRecipient;
            boolean skipRpc;
            if (jgAddressList == null) {
                skipRpc = membersSize < 2;
                boolean bl2 = singleRecipient = !ignoreLeavers && membersSize == 2;
                if (singleRecipient) {
                    singleJGAddress = localMembers.get(0).equals(self) ? JGroupsTransport.toJGroupsAddress(localMembers.get(1)) : JGroupsTransport.toJGroupsAddress(localMembers.get(0));
                }
            } else {
                skipRpc = false;
                boolean bl3 = singleRecipient = !ignoreLeavers && jgAddressList.size() == 1;
                if (singleRecipient) {
                    singleJGAddress = jgAddressList.get(0);
                }
            }
            if (skipRpc) {
                return CompletableFutures.completedEmptyMap();
            }
            if (singleRecipient) {
                singleResponseFuture = this.dispatcher.invokeRemoteCommand(singleJGAddress, rpcCommand, JGroupsTransport.toJGroupsMode(mode), timeout, deliverOrder);
            } else {
                rspListFuture = this.dispatcher.invokeRemoteCommands(jgAddressList, rpcCommand, JGroupsTransport.toJGroupsMode(mode), timeout, this.toJGroupsFilter(responseFilter), deliverOrder);
            }
        }
        if (mode.isAsynchronous()) {
            return CompletableFutures.completedEmptyMap();
        }
        if (singleResponseFuture != null) {
            org.jgroups.Address finalSingleJGAddress = singleJGAddress;
            return singleResponseFuture.thenApply(rsp -> {
                if (trace) {
                    log.tracef("Responses: %s", rsp);
                }
                Address sender = JGroupsTransport.fromJGroupsAddress(finalSingleJGAddress);
                Response response = this.checkRsp((Rsp<Response>)rsp, sender, this.ignoreTimeout(responseFilter), false);
                return Collections.singletonMap(sender, response);
            });
        }
        if (rspListFuture != null) {
            return rspListFuture.thenApply(rsps -> {
                if (trace) {
                    log.tracef("Responses: %s", rsps);
                }
                HashMap<Address, Response> responseMap = new HashMap<Address, Response>(CollectionFactory.computeCapacity(rsps.size()));
                boolean hasResponses = false;
                boolean hasValidResponses = false;
                if (rsps.isTimedOut()) {
                    throw this.addSuppressedExceptions(new TimeoutException("Replication timeout"), (Responses)rsps);
                }
                for (Map.Entry<org.jgroups.Address, Rsp<Response>> e : rsps) {
                    Rsp<Response> rsp = e.getValue();
                    if (rsp == null) continue;
                    hasResponses |= rsp.wasReceived();
                    Address sender = JGroupsTransport.fromJGroupsAddress(e.getKey());
                    Response response = this.checkRsp(rsp, sender, this.ignoreTimeout(responseFilter), ignoreLeavers);
                    if (response == null) continue;
                    hasValidResponses = true;
                    responseMap.put(sender, response);
                }
                if (!hasValidResponses) {
                    if (hasResponses) {
                        throw new RpcException(String.format("Received invalid responses from all of %s", recipients));
                    }
                    throw new TimeoutException("Timed out waiting for valid responses!");
                }
                return responseMap;
            });
        }
        throw new IllegalStateException("Should have one remote invocation future");
    }

    private TimeoutException addSuppressedExceptions(TimeoutException timeoutException, Responses rsps) {
        for (Map.Entry<org.jgroups.Address, Rsp<Response>> e : rsps) {
            Rsp<Response> rsp = e.getValue();
            if (rsp == null) continue;
            if (rsp.wasSuspected()) {
                timeoutException.addSuppressed(new RpcException(e.getKey() + " was suspected"));
                continue;
            }
            if (rsp.wasUnreachable()) {
                timeoutException.addSuppressed(new RpcException(e.getKey() + " was unreachable"));
                continue;
            }
            Throwable exception = rsp.getException();
            if (exception != null) {
                timeoutException.addSuppressed(exception);
                continue;
            }
            if (rsp.getValue() instanceof ExceptionResponse) {
                timeoutException.addSuppressed(((ExceptionResponse)rsp.getValue()).getException());
                continue;
            }
            timeoutException.addSuppressed(new RpcException("Not accepted: " + rsp.getValue()));
        }
        return timeoutException;
    }

    @Override
    public void sendTo(Address destination, ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        if (trace) {
            log.tracef("sendTo: destination=%s, command=%s, order=%s", (Object)destination, (Object)rpcCommand, (Object)deliverOrder);
        }
        if (destination.equals(this.address)) {
            if (trace) {
                log.trace("sendTo: not sending to self.");
            }
            return;
        }
        this.dispatcher.sendMessage(JGroupsTransport.toJGroupsAddress(destination), this.dispatcher.marshallCall(rpcCommand), JGroupsTransport.asyncRequestOptions(CommandAwareRpcDispatcher.isRsvpCommand(rpcCommand), deliverOrder));
    }

    @Override
    public void sendToMany(Collection<Address> destinations, ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        if (destinations == null) {
            this.sendToAll(rpcCommand, deliverOrder);
            return;
        }
        switch (destinations.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.sendTo(destinations.iterator().next(), rpcCommand, deliverOrder);
                return;
            }
        }
        if (trace) {
            log.tracef("sendTo: destinations=%s, command=%s, order=%s", (Object)destinations, (Object)rpcCommand, (Object)deliverOrder);
        }
        List<org.jgroups.Address> jgrpAddrList = this.toJGroupsAddressListExcludingSelf(destinations, deliverOrder == DeliverOrder.TOTAL);
        Buffer buffer = this.dispatcher.marshallCall(rpcCommand);
        RequestOptions options = JGroupsTransport.asyncRequestOptions(CommandAwareRpcDispatcher.isRsvpCommand(rpcCommand), deliverOrder);
        if (deliverOrder == DeliverOrder.TOTAL) {
            AnycastAddress anycastAddress = new AnycastAddress(jgrpAddrList);
            this.dispatcher.sendMessage(anycastAddress, buffer, options);
        } else if (jgrpAddrList.size() == 1) {
            this.dispatcher.sendMessage(jgrpAddrList.get(0), buffer, options);
        } else {
            this.dispatcher.castMessage(jgrpAddrList, buffer, options.anycasting(true).useAnycastAddresses(false));
        }
    }

    private static RequestOptions asyncRequestOptions(boolean rsvp, DeliverOrder deliverOrder) {
        return CommandAwareRpcDispatcher.constructRequestOptions(ResponseMode.GET_NONE, rsvp, deliverOrder, 0L, true);
    }

    private void sendToAll(ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        if (trace) {
            log.tracef("sendToAll: command=%s, order=%s", (Object)rpcCommand, (Object)deliverOrder);
        }
        Buffer buffer = this.dispatcher.marshallCall(rpcCommand);
        RequestOptions options = JGroupsTransport.asyncRequestOptions(CommandAwareRpcDispatcher.isRsvpCommand(rpcCommand), deliverOrder);
        if (deliverOrder == DeliverOrder.TOTAL) {
            this.dispatcher.sendMessage(new AnycastAddress(), buffer, options);
        } else {
            this.dispatcher.castMessage(null, buffer, options.anycasting(false));
        }
    }

    private boolean ignoreTimeout(ResponseFilter responseFilter) {
        return responseFilter != null && !responseFilter.needMoreResponses();
    }

    @Override
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, org.infinispan.remoting.rpc.ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter, boolean totalOrder, boolean anycast) throws Exception {
        DeliverOrder deliverOrder = DeliverOrder.PER_SENDER;
        if (totalOrder) {
            deliverOrder = DeliverOrder.TOTAL;
        } else if (usePriorityQueue) {
            deliverOrder = DeliverOrder.NONE;
        }
        return this.invokeRemotely(rpcCommands, mode, timeout, responseFilter, deliverOrder, anycast);
    }

    @Override
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, org.infinispan.remoting.rpc.ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        if (rpcCommands == null || rpcCommands.isEmpty()) {
            log.trace("Destination list is empty: no need to send message");
            return Collections.emptyMap();
        }
        if (trace) {
            log.tracef("commands=%s, mode=%s, timeout=%s", (Object)rpcCommands, (Object)mode, (Object)timeout);
        }
        boolean ignoreLeavers = mode == org.infinispan.remoting.rpc.ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS || mode == org.infinispan.remoting.rpc.ResponseMode.WAIT_FOR_VALID_RESPONSE;
        SingleResponseFuture[] futures = new SingleResponseFuture[rpcCommands.size()];
        int i = 0;
        for (Map.Entry<Address, ReplicableCommand> entry : rpcCommands.entrySet()) {
            SingleResponseFuture future;
            org.jgroups.Address recipient = JGroupsTransport.toJGroupsAddress(entry.getKey());
            ReplicableCommand command = entry.getValue();
            futures[i] = future = this.dispatcher.invokeRemoteCommand(recipient, command, JGroupsTransport.toJGroupsMode(mode), timeout, deliverOrder);
            ++i;
        }
        if (mode.isAsynchronous()) {
            return Collections.emptyMap();
        }
        CompletableFuture<Void> bigFuture = CompletableFuture.allOf(futures);
        CompletableFutures.await(bigFuture);
        HashMap<Address, Response> retval = new HashMap<Address, Response>(CollectionFactory.computeCapacity(futures.length));
        boolean hasResponses = false;
        i = 0;
        for (Map.Entry<Address, ReplicableCommand> addressReplicableCommandEntry : rpcCommands.entrySet()) {
            Address sender = addressReplicableCommandEntry.getKey();
            Rsp rsp = (Rsp)futures[i].get();
            Response response = this.checkRsp(rsp, sender, this.ignoreTimeout(responseFilter), ignoreLeavers);
            if (response != null) {
                retval.put(sender, response);
                hasResponses = true;
            }
            ++i;
        }
        if (!hasResponses) {
            throw new TimeoutException("Timed out waiting for valid responses!");
        }
        return retval;
    }

    @Override
    public BackupResponse backupRemotely(Collection<XSiteBackup> backups, XSiteReplicateCommand rpcCommand) throws Exception {
        if (trace) {
            log.tracef("About to send to backups %s, command %s", (Object)backups, (Object)rpcCommand);
        }
        Buffer buf = this.dispatcher.marshallCall(rpcCommand);
        HashMap<XSiteBackup, Future<Object>> syncBackupCalls = new HashMap<XSiteBackup, Future<Object>>(backups.size());
        for (XSiteBackup xsb : backups) {
            SiteMaster recipient = new SiteMaster(xsb.getSiteName());
            if (xsb.isSync()) {
                RequestOptions sync = CommandAwareRpcDispatcher.constructRequestOptions(ResponseMode.GET_ALL, false, DeliverOrder.NONE, xsb.getTimeout(), false);
                syncBackupCalls.put(xsb, this.dispatcher.sendMessageWithFuture(recipient, buf.getBuf(), buf.getOffset(), buf.getLength(), sync));
                continue;
            }
            RequestOptions async = CommandAwareRpcDispatcher.constructRequestOptions(ResponseMode.GET_NONE, false, DeliverOrder.PER_SENDER, xsb.getTimeout(), false);
            this.dispatcher.sendMessage(recipient, buf.getBuf(), buf.getOffset(), buf.getLength(), async);
        }
        return new JGroupsBackupResponse(syncBackupCalls, this.timeService);
    }

    private static ResponseMode toJGroupsMode(org.infinispan.remoting.rpc.ResponseMode mode) {
        switch (mode) {
            case ASYNCHRONOUS: {
                return ResponseMode.GET_NONE;
            }
            case WAIT_FOR_VALID_RESPONSE: {
                return ResponseMode.GET_FIRST;
            }
            case SYNCHRONOUS: 
            case SYNCHRONOUS_IGNORE_LEAVERS: {
                return ResponseMode.GET_ALL;
            }
        }
        throw new CacheException("Unknown response mode " + (Object)((Object)mode));
    }

    private RspFilter toJGroupsFilter(ResponseFilter responseFilter) {
        return responseFilter == null ? null : new JGroupsResponseFilterAdapter(responseFilter);
    }

    protected Response checkRsp(Rsp<Response> rsp, Address sender, boolean ignoreTimeout, boolean ignoreLeavers) {
        Response response;
        if (rsp.wasReceived()) {
            if (rsp.hasException()) {
                log.tracef(rsp.getException(), "Unexpected exception from %s", (Object)sender);
                throw log.remoteException(sender, rsp.getException());
            }
            response = this.checkResponse(rsp.getValue(), sender, ignoreLeavers);
        } else if (rsp.wasSuspected()) {
            response = this.checkResponse(CacheNotFoundResponse.INSTANCE, sender, ignoreLeavers);
        } else {
            if (!ignoreTimeout) {
                throw new TimeoutException("Replication timeout for " + sender);
            }
            response = null;
        }
        return response;
    }

    private void addXSiteViewListener() {
        RELAY2 relay2 = (RELAY2)this.channel.getProtocolStack().findProtocol((Class<? extends Protocol>)RELAY2.class);
        if (relay2 != null && relay2.getRouteStatusListener() == null) {
            relay2.setRouteStatusListener(new DefaultRouteStatusListener());
        }
    }

    private void addSiteMasterPicker() {
        RELAY2 relay2 = (RELAY2)this.channel.getProtocolStack().findProtocol((Class<? extends Protocol>)RELAY2.class);
        if (relay2 != null) {
            relay2.siteMasterPicker(new SiteMasterPickerImpl());
        }
    }

    @Override
    public Set<String> getSitesView() {
        RELAY2 relay = (RELAY2)this.channel.getProtocolStack().findProtocol((Class<? extends Protocol>)RELAY2.class);
        RouteStatusListener listener = relay != null ? relay.getRouteStatusListener() : null;
        return listener instanceof Supplier ? (Set)((Supplier)((Object)listener)).get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewAccepted(View newView) {
        boolean hasNotifier;
        log.debugf("New view accepted: %s", (Object)newView);
        List<org.jgroups.Address> newMembers = newView.getMembers();
        if (newMembers == null || newMembers.isEmpty()) {
            log.debugf("Received null or empty member list from JGroups channel: " + newView, new Object[0]);
            return;
        }
        List<Address> oldMembers = this.members;
        CompletableFuture<Void> oldFuture = null;
        this.viewUpdateLock.lock();
        try {
            this.viewId = (int)newView.getViewId().getId();
            this.members = JGroupsTransport.fromJGroupsAddressList(newMembers);
            if (log.isDebugEnabled() && oldMembers != null) {
                ArrayList<Address> joined = new ArrayList<Address>(this.members);
                joined.removeAll(oldMembers);
                ArrayList<Address> left = new ArrayList<Address>(oldMembers);
                left.removeAll(this.members);
                log.debugf("Joined: %s, Left: %s", (Object)joined, (Object)left);
            }
            if (this.address == null) {
                this.address = JGroupsTransport.fromJGroupsAddress(this.channel.getAddress());
            }
            this.coordinator = JGroupsTransport.fromJGroupsAddress(newView.getCreator());
            this.isCoordinator = this.coordinator != null && this.coordinator.equals(this.address);
            oldFuture = this.nextViewFuture;
            this.nextViewFuture = new CompletableFuture();
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
            if (oldFuture != null) {
                oldFuture.complete(null);
            }
        }
        boolean bl = hasNotifier = this.notifier != null;
        if (hasNotifier) {
            Notify n;
            String clusterName = this.configuration.transport().clusterName();
            if (newView instanceof MergeView) {
                log.receivedMergedView(clusterName, newView);
                n = new NotifyMerge();
            } else {
                log.receivedClusterView(clusterName, newView);
                n = new NotifyViewChange();
            }
            n.emitNotification(oldMembers, newView);
        }
        JGroupsAddressCache.pruneAddressCache();
    }

    @Override
    public void suspect(org.jgroups.Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void unblock() {
    }

    protected static org.jgroups.Address toJGroupsAddress(Address a) {
        return ((JGroupsAddress)a).address;
    }

    static Address fromJGroupsAddress(org.jgroups.Address addr) {
        return JGroupsAddressCache.fromJGroupsAddress(addr);
    }

    private List<org.jgroups.Address> toJGroupsAddressListExcludingSelf(Collection<Address> list, boolean totalOrder) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<org.jgroups.Address> retval = new ArrayList<org.jgroups.Address>(list.size());
        boolean ignoreSelf = !totalOrder;
        Address self = this.getAddress();
        for (Address a : list) {
            if (!ignoreSelf || !a.equals(self)) {
                retval.add(JGroupsTransport.toJGroupsAddress(a));
                continue;
            }
            ignoreSelf = false;
        }
        return retval;
    }

    private static List<Address> fromJGroupsAddressList(List<org.jgroups.Address> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Address> retval = new ArrayList<Address>(list.size());
        for (org.jgroups.Address a : list) {
            retval.add(JGroupsTransport.fromJGroupsAddress(a));
        }
        return Collections.unmodifiableList(retval);
    }

    public CommandAwareRpcDispatcher getCommandAwareRpcDispatcher() {
        return this.dispatcher;
    }

    public JChannel getChannel() {
        return this.channel;
    }

    @Override
    public final void checkTotalOrderSupported() {
        if (this.channel.getProtocolStack().findProtocol((Class<? extends Protocol>)TOA.class) == null) {
            throw new CacheConfigurationException("In order to support total order based transaction, the TOA protocol must be present in the JGroups's config.");
        }
    }

    class DefaultRouteStatusListener
    implements RouteStatusListener,
    Supplier<Set<String>> {
        private final Set<String> view = new ConcurrentSkipListSet<String>();

        DefaultRouteStatusListener() {
        }

        @Override
        public void sitesUp(String ... sites) {
            this.view.addAll(Arrays.asList(sites));
            log.receivedXSiteClusterView(this.view);
        }

        @Override
        public void sitesDown(String ... sites) {
            this.view.removeAll(Arrays.asList(sites));
            log.receivedXSiteClusterView(this.view);
        }

        @Override
        public Set<String> get() {
            return Collections.unmodifiableSet(this.view);
        }
    }

    private class NotifyMerge
    implements Notify {
        private NotifyMerge() {
        }

        @Override
        public void emitNotification(List<Address> oldMembers, View newView) {
            MergeView mv = (MergeView)newView;
            Address address = JGroupsTransport.this.getAddress();
            int viewId = (int)newView.getViewId().getId();
            JGroupsTransport.this.notifier.notifyMerge(JGroupsTransport.this.members, oldMembers, address, viewId, this.getSubgroups(mv.getSubgroups()));
        }

        private List<List<Address>> getSubgroups(List<View> subviews) {
            ArrayList<List<Address>> l = new ArrayList<List<Address>>(subviews.size());
            for (View v : subviews) {
                l.add(JGroupsTransport.fromJGroupsAddressList(v.getMembers()));
            }
            return l;
        }
    }

    private class NotifyViewChange
    implements Notify {
        private NotifyViewChange() {
        }

        @Override
        public void emitNotification(List<Address> oldMembers, View newView) {
            JGroupsTransport.this.notifier.notifyViewChange(JGroupsTransport.this.members, oldMembers, JGroupsTransport.this.getAddress(), (int)newView.getViewId().getId());
        }
    }

    private static interface Notify {
        public void emitNotification(List<Address> var1, View var2);
    }
}

