/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.Messages;

public class PreferConsistencyStrategy
implements AvailabilityStrategy {
    private static final Log log = LogFactory.getLog(PreferConsistencyStrategy.class);
    private final EventLogManager eventLogManager;
    private final PersistentUUIDManager persistentUUIDManager;

    public PreferConsistencyStrategy(EventLogManager eventLogManager, PersistentUUIDManager persistentUUIDManager) {
        this.eventLogManager = eventLogManager;
        this.persistentUUIDManager = persistentUUIDManager;
    }

    @Override
    public void onJoin(AvailabilityStrategyContext context, Address joiner) {
        if (context.getAvailabilityMode() != AvailabilityMode.AVAILABLE) {
            log.debugf("Cache %s not available (%s), postponing rebalance for joiner %s", (Object)context.getCacheName(), (Object)context.getAvailabilityMode(), (Object)joiner);
            return;
        }
        context.queueRebalance(context.getExpectedMembers());
    }

    @Override
    public void onGracefulLeave(AvailabilityStrategyContext context, Address leaver) {
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        newMembers.remove(leaver);
        if (newMembers.isEmpty()) {
            log.debugf("The last node of cache %s left", (Object)context.getCacheName());
            context.updateCurrentTopology(newMembers);
            return;
        }
        if (context.getAvailabilityMode() != AvailabilityMode.AVAILABLE) {
            log.debugf("Cache %s is not available, ignoring graceful leaver %s", (Object)context.getCacheName(), (Object)leaver);
            return;
        }
        if (this.isDataLost(context.getStableTopology().getCurrentCH(), newMembers)) {
            this.eventLogManager.getEventLogger().context(context.getCacheName()).warn(EventLogCategory.CLUSTER, Messages.MESSAGES.enteringDegradedModeGracefulLeaver(leaver));
            context.updateAvailabilityMode(newMembers, AvailabilityMode.DEGRADED_MODE, true);
            return;
        }
        this.updateMembersAndRebalance(context, newMembers, newMembers);
    }

    @Override
    public void onClusterViewChange(AvailabilityStrategyContext context, List<Address> clusterMembers) {
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        if (!newMembers.retainAll(clusterMembers)) {
            log.debugf("Cache %s did not lose any members, ignoring view change", (Object)context.getCacheName());
            return;
        }
        if (context.getAvailabilityMode() != AvailabilityMode.AVAILABLE) {
            log.debugf("Cache %s is not available, updating the actual members only", (Object)context.getCacheName());
            context.updateAvailabilityMode(newMembers, context.getAvailabilityMode(), false);
            return;
        }
        CacheTopology stableTopology = context.getStableTopology();
        List<Address> stableMembers = stableTopology.getMembers();
        ArrayList<Address> lostMembers = new ArrayList<Address>(stableMembers);
        lostMembers.removeAll(newMembers);
        if (this.isDataLost(stableTopology.getCurrentCH(), newMembers)) {
            this.eventLogManager.getEventLogger().context(context.getCacheName()).error(EventLogCategory.CLUSTER, Messages.MESSAGES.enteringDegradedModeLostData(lostMembers));
            context.updateAvailabilityMode(newMembers, AvailabilityMode.DEGRADED_MODE, true);
            return;
        }
        if (this.isMinorityPartition(stableMembers, lostMembers)) {
            this.eventLogManager.getEventLogger().context(context.getCacheName()).error(EventLogCategory.CLUSTER, Messages.MESSAGES.enteringDegradedModeMinorityPartition(newMembers, lostMembers, stableMembers));
            context.updateAvailabilityMode(newMembers, AvailabilityMode.DEGRADED_MODE, true);
            return;
        }
        this.updateMembersAndRebalance(context, newMembers, newMembers);
    }

    protected boolean isMinorityPartition(List<Address> stableMembers, List<Address> lostMembers) {
        return (double)lostMembers.size() >= Math.ceil((double)stableMembers.size() / 2.0);
    }

    @Override
    public void onPartitionMerge(AvailabilityStrategyContext context, Map<Address, CacheStatusResponse> statusResponseMap) {
        AvailabilityMode mergedAvailabilityMode;
        CacheTopology mergedTopology;
        int maxTopologyId = 0;
        CacheTopology maxStableTopology = null;
        CacheTopology maxActiveTopology = null;
        HashSet<CacheTopology> degradedTopologies = new HashSet<CacheTopology>();
        CacheTopology maxDegradedTopology = null;
        for (CacheStatusResponse response : statusResponseMap.values()) {
            CacheTopology partitionTopology;
            CacheTopology partitionStableTopology = response.getStableTopology();
            if (partitionStableTopology == null) continue;
            if (maxStableTopology == null || maxStableTopology.getTopologyId() < partitionStableTopology.getTopologyId()) {
                maxStableTopology = partitionStableTopology;
            }
            if ((partitionTopology = response.getCacheTopology()) == null) continue;
            if (partitionTopology.getTopologyId() > maxTopologyId) {
                maxTopologyId = partitionTopology.getTopologyId();
            }
            if (response.getAvailabilityMode() == AvailabilityMode.AVAILABLE) {
                if (maxActiveTopology != null && maxActiveTopology.getTopologyId() >= partitionTopology.getTopologyId()) continue;
                maxActiveTopology = partitionTopology;
                continue;
            }
            if (response.getAvailabilityMode() == AvailabilityMode.DEGRADED_MODE) {
                degradedTopologies.add(partitionTopology);
                if (maxDegradedTopology != null && maxDegradedTopology.getTopologyId() >= partitionTopology.getTopologyId()) continue;
                maxDegradedTopology = partitionTopology;
                continue;
            }
            this.eventLogManager.getEventLogger().context(context.getCacheName()).error(EventLogCategory.CLUSTER, Messages.MESSAGES.unexpectedAvailabilityMode(context.getAvailabilityMode(), response.getCacheTopology()));
        }
        if (maxStableTopology != null) {
            log.tracef("Max stable partition topology: %s", (Object)maxStableTopology);
        }
        if (maxActiveTopology != null) {
            log.tracef("Max active partition topology: %s", (Object)maxActiveTopology);
        }
        if (maxDegradedTopology != null) {
            log.tracef("Max degraded partition topology: %s, all degraded: %s", (Object)maxDegradedTopology, (Object)degradedTopologies);
        }
        ArrayList<Address> actualMembers = new ArrayList<Address>(context.getExpectedMembers());
        if (maxActiveTopology != null) {
            log.debugf("One of the partitions is available, using that partition's topology", new Object[0]);
            mergedTopology = maxActiveTopology;
            actualMembers.retainAll(mergedTopology.getMembers());
            mergedAvailabilityMode = AvailabilityMode.AVAILABLE;
        } else if (!degradedTopologies.isEmpty()) {
            log.debugf("No active partitions, so all the partitions must be in degraded mode.", new Object[0]);
            mergedTopology = maxDegradedTopology;
            actualMembers.retainAll(mergedTopology.getMembers());
            mergedAvailabilityMode = AvailabilityMode.DEGRADED_MODE;
        } else {
            log.debugf("No current topology, recovered only joiners for cache %s. Skipping availability update.", (Object)context.getCacheName());
            return;
        }
        if (mergedTopology != null) {
            mergedTopology = new CacheTopology(maxTopologyId + 1, mergedTopology.getRebalanceId(), mergedTopology.getCurrentCH(), null, CacheTopology.Phase.NO_REBALANCE, actualMembers, this.persistentUUIDManager.mapAddresses(actualMembers));
        }
        context.updateTopologiesAfterMerge(mergedTopology, maxStableTopology, mergedAvailabilityMode, false);
        AvailabilityMode newAvailabilityMode = this.computeAvailabilityAfterMerge(context, maxStableTopology, actualMembers);
        if (newAvailabilityMode == AvailabilityMode.DEGRADED_MODE) {
            log.debugf("After merge, cache %s is staying in degraded mode", (Object)context.getCacheName());
            context.updateAvailabilityMode(actualMembers, newAvailabilityMode, true);
        } else {
            log.debugf("After merge, cache %s has recovered and is entering available mode", (Object)context.getCacheName());
            this.updateMembersAndRebalance(context, actualMembers, context.getExpectedMembers());
        }
    }

    private AvailabilityMode computeAvailabilityAfterMerge(AvailabilityStrategyContext context, CacheTopology maxStableTopology, List<Address> newMembers) {
        if (maxStableTopology != null) {
            List<Address> stableMembers = maxStableTopology.getMembers();
            ArrayList<Address> lostMembers = new ArrayList<Address>(stableMembers);
            lostMembers.removeAll(context.getExpectedMembers());
            if (this.isDataLost(maxStableTopology.getCurrentCH(), newMembers)) {
                this.eventLogManager.getEventLogger().context(context.getCacheName()).error(EventLogCategory.CLUSTER, Messages.MESSAGES.keepingDegradedModeAfterMergeDataLost(newMembers, lostMembers, stableMembers));
                return AvailabilityMode.DEGRADED_MODE;
            }
            if ((double)lostMembers.size() >= Math.ceil((double)stableMembers.size() / 2.0)) {
                this.eventLogManager.getEventLogger().context(context.getCacheName()).warn(EventLogCategory.CLUSTER, Messages.MESSAGES.keepingDegradedModeAfterMergeMinorityPartition(newMembers, lostMembers, stableMembers));
                return AvailabilityMode.DEGRADED_MODE;
            }
        }
        return AvailabilityMode.AVAILABLE;
    }

    @Override
    public void onRebalanceEnd(AvailabilityStrategyContext context) {
    }

    @Override
    public void onManualAvailabilityChange(AvailabilityStrategyContext context, AvailabilityMode newAvailabilityMode) {
        List<Address> actualMembers = context.getCurrentTopology().getActualMembers();
        List<Address> newMembers = context.getExpectedMembers();
        if (newAvailabilityMode == AvailabilityMode.AVAILABLE) {
            context.updateCurrentTopology(actualMembers);
            context.updateAvailabilityMode(actualMembers, newAvailabilityMode, false);
            context.queueRebalance(newMembers);
        } else {
            context.updateAvailabilityMode(actualMembers, newAvailabilityMode, true);
        }
    }

    private void updateMembersAndRebalance(AvailabilityStrategyContext context, List<Address> actualMembers, List<Address> newMembers) {
        context.updateAvailabilityMode(actualMembers, AvailabilityMode.AVAILABLE, false);
        context.updateCurrentTopology(newMembers);
        context.queueRebalance(context.getExpectedMembers());
    }

    private boolean isDataLost(ConsistentHash currentCH, List<Address> newMembers) {
        for (int i = 0; i < currentCH.getNumSegments(); ++i) {
            if (InfinispanCollections.containsAny(newMembers, currentCH.locateOwnersForSegment(i))) continue;
            return true;
        }
        return false;
    }
}

