/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.MessageMarshallerDelegate;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.WriteMessageContext;
import org.jboss.logging.Logger;

final class ProtoStreamWriterImpl
implements MessageMarshaller.ProtoStreamWriter {
    private static final Log log = Log.LogFactory.getLog(ProtoStreamWriterImpl.class);
    private static final int CHUNK_SIZE = 4096;
    private final SerializationContextImpl ctx;
    private WriteMessageContext messageContext;

    ProtoStreamWriterImpl(SerializationContextImpl ctx) {
        this.ctx = ctx;
    }

    WriteMessageContext pushContext(FieldDescriptor fd, MessageMarshallerDelegate<?> marshallerDelegate, RawProtoStreamWriter out) {
        this.messageContext = new WriteMessageContext(this.messageContext, fd == null ? null : fd.getName(), marshallerDelegate, out);
        return this.messageContext;
    }

    void popContext() {
        this.messageContext = (WriteMessageContext)this.messageContext.getParentContext();
    }

    @Override
    public ImmutableSerializationContext getSerializationContext() {
        return this.ctx;
    }

    @Override
    public void writeInt(String fieldName, int value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        switch (fd.getType()) {
            case INT32: {
                this.messageContext.out.writeInt32(fd.getNumber(), value);
                break;
            }
            case FIXED32: {
                this.messageContext.out.writeFixed32(fd.getNumber(), value);
                break;
            }
            case UINT32: {
                this.messageContext.out.writeUInt32(fd.getNumber(), value);
                break;
            }
            case SFIXED32: {
                this.messageContext.out.writeSFixed32(fd.getNumber(), value);
                break;
            }
            case SINT32: {
                this.messageContext.out.writeSInt32(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeInt(String fieldName, Integer value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        switch (fd.getType()) {
            case INT32: {
                this.messageContext.out.writeInt32(fd.getNumber(), value);
                break;
            }
            case FIXED32: {
                this.messageContext.out.writeFixed32(fd.getNumber(), value);
                break;
            }
            case UINT32: {
                this.messageContext.out.writeUInt32(fd.getNumber(), value);
                break;
            }
            case SFIXED32: {
                this.messageContext.out.writeSFixed32(fd.getNumber(), value);
                break;
            }
            case SINT32: {
                this.messageContext.out.writeSInt32(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeInts(String fieldName, int[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        RawProtoStreamWriter out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        switch (fd.getType()) {
            case INT32: {
                for (int value : array) {
                    out.writeInt32(fieldNumber, value);
                }
                break;
            }
            case FIXED32: {
                for (int value : array) {
                    out.writeFixed32(fieldNumber, value);
                }
                break;
            }
            case UINT32: {
                for (int value : array) {
                    out.writeUInt32(fieldNumber, value);
                }
                break;
            }
            case SFIXED32: {
                for (int value : array) {
                    out.writeSFixed32(fieldNumber, value);
                }
                break;
            }
            case SINT32: {
                for (int value : array) {
                    out.writeSInt32(fieldNumber, value);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeLong(String fieldName, long value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        switch (fd.getType()) {
            case INT64: {
                this.messageContext.out.writeInt64(fd.getNumber(), value);
                break;
            }
            case UINT64: {
                this.messageContext.out.writeUInt64(fd.getNumber(), value);
                break;
            }
            case FIXED64: {
                this.messageContext.out.writeFixed64(fd.getNumber(), value);
                break;
            }
            case SFIXED64: {
                this.messageContext.out.writeSFixed64(fd.getNumber(), value);
                break;
            }
            case SINT64: {
                this.messageContext.out.writeSInt64(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeLong(String fieldName, Long value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        switch (fd.getType()) {
            case INT64: {
                this.messageContext.out.writeInt64(fd.getNumber(), value);
                break;
            }
            case UINT64: {
                this.messageContext.out.writeUInt64(fd.getNumber(), value);
                break;
            }
            case FIXED64: {
                this.messageContext.out.writeFixed64(fd.getNumber(), value);
                break;
            }
            case SFIXED64: {
                this.messageContext.out.writeSFixed64(fd.getNumber(), value);
                break;
            }
            case SINT64: {
                this.messageContext.out.writeSInt64(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeLongs(String fieldName, long[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        RawProtoStreamWriter out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        switch (fd.getType()) {
            case INT64: {
                for (long value : array) {
                    out.writeInt64(fieldNumber, value);
                }
                break;
            }
            case FIXED64: {
                for (long value : array) {
                    out.writeFixed64(fieldNumber, value);
                }
                break;
            }
            case UINT64: {
                for (long value : array) {
                    out.writeUInt64(fieldNumber, value);
                }
                break;
            }
            case SFIXED64: {
                for (long value : array) {
                    out.writeSFixed64(fieldNumber, value);
                }
                break;
            }
            case SINT64: {
                for (long value : array) {
                    out.writeSInt64(fieldNumber, value);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeDate(String fieldName, Date value) throws IOException {
        if (value != null) {
            this.writeLong(fieldName, value.getTime());
        }
    }

    @Override
    public void writeInstant(String fieldName, Instant value) throws IOException {
        if (value != null) {
            this.writeLong(fieldName, value.toEpochMilli());
        }
    }

    @Override
    public void writeDouble(String fieldName, double value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (fd.getType() != Type.DOUBLE) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.messageContext.out.writeDouble(fd.getNumber(), value);
    }

    @Override
    public void writeDouble(String fieldName, Double value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (fd.getType() != Type.DOUBLE) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.messageContext.out.writeDouble(fd.getNumber(), value);
    }

    @Override
    public void writeDoubles(String fieldName, double[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (fd.getType() != Type.DOUBLE) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        RawProtoStreamWriter out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        for (double value : array) {
            out.writeDouble(fieldNumber, value);
        }
    }

    @Override
    public void writeFloat(String fieldName, float value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (fd.getType() != Type.FLOAT) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.checkFieldWrite(fd);
        this.messageContext.out.writeFloat(fd.getNumber(), value);
    }

    @Override
    public void writeFloat(String fieldName, Float value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (fd.getType() != Type.FLOAT) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.messageContext.out.writeFloat(fd.getNumber(), value.floatValue());
    }

    @Override
    public void writeFloats(String fieldName, float[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (fd.getType() != Type.FLOAT) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        RawProtoStreamWriter out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        for (float value : array) {
            out.writeFloat(fieldNumber, value);
        }
    }

    @Override
    public void writeBoolean(String fieldName, boolean value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (fd.getType() != Type.BOOL) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.checkFieldWrite(fd);
        this.messageContext.out.writeBool(fd.getNumber(), value);
    }

    @Override
    public void writeBoolean(String fieldName, Boolean value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (fd.getType() != Type.BOOL) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.messageContext.out.writeBool(fd.getNumber(), value);
    }

    @Override
    public void writeBooleans(String fieldName, boolean[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (fd.getType() != Type.BOOL) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        RawProtoStreamWriter out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        for (boolean value : array) {
            out.writeBool(fieldNumber, value);
        }
    }

    @Override
    public void writeString(String fieldName, String value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (fd.getType() != Type.STRING) {
            throw new IllegalArgumentException("Declared field type is not of type string : " + fieldName);
        }
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.messageContext.out.writeString(fd.getNumber(), value);
    }

    @Override
    public void writeBytes(String fieldName, byte[] value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (fd.getType() != Type.BYTES) {
            throw new IllegalArgumentException("Declared field type is not of type bytes : " + fieldName);
        }
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.messageContext.out.writeBytes(fd.getNumber(), value);
    }

    @Override
    public void writeBytes(String fieldName, InputStream input) throws IOException {
        int bufLen;
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (fd.getType() != Type.BYTES) {
            throw new IllegalArgumentException("Declared field type is not of type bytes : " + fieldName);
        }
        if (input == null) {
            throw new IllegalArgumentException("The input stream cannot be null");
        }
        int len = 0;
        LinkedList<byte[]> chunks = new LinkedList<byte[]>();
        byte[] buffer = new byte[4096];
        while ((bufLen = input.read(buffer)) != -1) {
            chunks.add(buffer);
            len += bufLen;
            buffer = new byte[4096];
        }
        input.close();
        RawProtoStreamWriter out = this.messageContext.out;
        out.writeTag(fd.getNumber(), 2);
        out.writeUInt32NoTag(len);
        for (byte[] chunk : chunks) {
            out.writeRawBytes(buffer, 0, chunk == buffer ? bufLen : 4096);
        }
    }

    @Override
    public <E> void writeObject(String fieldName, E value, Class<? extends E> clazz) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        if (fd.getType() == Type.GROUP) {
            this.writeGroup(fd, value, clazz);
        } else if (fd.getType() == Type.MESSAGE) {
            this.writeMessage(fd, value, clazz);
        } else if (fd.getType() == Type.ENUM) {
            this.writeEnum(fd, (Enum)value);
        } else {
            throw new IllegalArgumentException("Declared field type is not a message or an enum : " + fieldName);
        }
    }

    @Override
    public <E extends Enum<E>> void writeEnum(String fieldName, E value, Class<E> clazz) throws IOException {
        this.writeObject(fieldName, value, clazz);
    }

    private void writeMessage(FieldDescriptor fd, Object value, Class clazz) throws IOException {
        BaseMarshallerDelegate<Object> marshallerDelegate = this.ctx.getMarshallerDelegate(clazz);
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx();
        RawProtoStreamWriter out = RawProtoStreamWriterImpl.newInstance(baos);
        marshallerDelegate.marshall(fd, value, this, out);
        out.flush();
        this.messageContext.out.writeBytes(fd.getNumber(), baos.getByteBuffer());
    }

    private void writeGroup(FieldDescriptor fd, Object value, Class clazz) throws IOException {
        BaseMarshallerDelegate<Object> marshallerDelegate = this.ctx.getMarshallerDelegate(clazz);
        this.messageContext.out.writeTag(fd.getNumber(), 3);
        marshallerDelegate.marshall(fd, value, this, this.messageContext.out);
        this.messageContext.out.writeTag(fd.getNumber(), 4);
    }

    private <T extends Enum<T>> void writeEnum(FieldDescriptor fd, T value) throws IOException {
        BaseMarshallerDelegate<?> marshallerDelegate = this.ctx.getMarshallerDelegate(value.getClass());
        marshallerDelegate.marshall(fd, value, this, this.messageContext.out);
    }

    @Override
    public <E> void writeCollection(String fieldName, Collection<? super E> collection, Class<E> elementClass) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkRepeatedFieldWrite(fd);
        if (collection == null) {
            return;
        }
        RawProtoStreamWriter out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        switch (fd.getType()) {
            case GROUP: {
                for (E t : collection) {
                    this.validateElement(t, elementClass);
                    this.writeGroup(fd, t, elementClass);
                }
                break;
            }
            case MESSAGE: {
                for (E t : collection) {
                    this.validateElement(t, elementClass);
                    this.writeMessage(fd, t, elementClass);
                }
                break;
            }
            case ENUM: {
                for (E t : collection) {
                    this.validateElement(t, elementClass);
                    this.writeEnum(fd, (Enum)t);
                }
                break;
            }
            case DOUBLE: {
                this.validateElementClass(elementClass, Double.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeDouble(fieldNumber, (Double)value);
                }
                break;
            }
            case FLOAT: {
                this.validateElementClass(elementClass, Float.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeFloat(fieldNumber, ((Float)value).floatValue());
                }
                break;
            }
            case BOOL: {
                this.validateElementClass(elementClass, Boolean.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeBool(fieldNumber, (Boolean)value);
                }
                break;
            }
            case STRING: {
                this.validateElementClass(elementClass, String.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeString(fieldNumber, (String)value);
                }
                break;
            }
            case BYTES: {
                this.validateElementClass(elementClass, byte[].class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeBytes(fieldNumber, (byte[])value);
                }
                break;
            }
            case INT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case UINT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeUInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case FIXED64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeFixed64(fieldNumber, (Long)value);
                }
                break;
            }
            case SFIXED64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeSFixed64(fieldNumber, (Long)value);
                }
                break;
            }
            case SINT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeSInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case INT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            case FIXED32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeFixed32(fieldNumber, (Integer)value);
                }
                break;
            }
            case UINT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeUInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            case SFIXED32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeSFixed32(fieldNumber, (Integer)value);
                }
                break;
            }
            case SINT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeSInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public <E> void writeArray(String fieldName, E[] array, Class<? extends E> elementClass) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        RawProtoStreamWriter out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        switch (fd.getType()) {
            case GROUP: {
                for (E t : array) {
                    this.validateElement(t, elementClass);
                    this.writeGroup(fd, t, elementClass);
                }
                break;
            }
            case MESSAGE: {
                for (E t : array) {
                    this.validateElement(t, elementClass);
                    this.writeMessage(fd, t, elementClass);
                }
                break;
            }
            case ENUM: {
                for (E t : array) {
                    this.validateElement(t, elementClass);
                    this.writeEnum(fd, (Enum)t);
                }
                break;
            }
            case DOUBLE: {
                this.validateElementClass(elementClass, Double.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeDouble(fieldNumber, (Double)value);
                }
                break;
            }
            case FLOAT: {
                this.validateElementClass(elementClass, Float.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeFloat(fieldNumber, ((Float)value).floatValue());
                }
                break;
            }
            case BOOL: {
                this.validateElementClass(elementClass, Boolean.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeBool(fieldNumber, (Boolean)value);
                }
                break;
            }
            case STRING: {
                this.validateElementClass(elementClass, String.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeString(fieldNumber, (String)value);
                }
                break;
            }
            case BYTES: {
                this.validateElementClass(elementClass, byte[].class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeBytes(fieldNumber, (byte[])value);
                }
                break;
            }
            case INT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case UINT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeUInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case FIXED64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeFixed64(fieldNumber, (Long)value);
                }
                break;
            }
            case SFIXED64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeSFixed64(fieldNumber, (Long)value);
                }
                break;
            }
            case SINT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeSInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case INT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            case FIXED32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeFixed32(fieldNumber, (Integer)value);
                }
                break;
            }
            case UINT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeUInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            case SFIXED32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeSFixed32(fieldNumber, (Integer)value);
                }
                break;
            }
            case SINT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeSInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    private void validateElementClass(Class<?> elementClass, Class<?> expectedElementClass) {
        if (elementClass != expectedElementClass) {
            throw new IllegalArgumentException("elementClass argument should be " + expectedElementClass.getName());
        }
    }

    private void validateElement(Object element, Class<?> elementClass) {
        if (element == null) {
            throw new IllegalArgumentException("Collection or array element cannot be null");
        }
        if (element.getClass() != elementClass) {
            throw new IllegalArgumentException("Collection or array element is expected to be an instance of " + elementClass.getName());
        }
    }

    private void checkFieldWrite(FieldDescriptor fd) {
        if (fd.isRepeated()) {
            throw new IllegalStateException("A repeated field should be written with one of the methods intended for collections or arrays: " + fd.getFullName());
        }
        if (!this.messageContext.markField(fd.getNumber())) {
            throw new IllegalStateException("A field cannot be written twice : " + fd.getFullName());
        }
        if (this.ctx.getConfiguration().logOutOfSequenceWrites() && log.isEnabled(Logger.Level.WARN) && this.messageContext.getMaxSeenFieldNumber() > fd.getNumber()) {
            log.fieldWriteOutOfSequence(fd.getFullName());
        }
    }

    private void checkRepeatedFieldWrite(FieldDescriptor fd) {
        if (!fd.isRepeated()) {
            throw new IllegalStateException("This field is not repeated and cannot be written with the methods intended for collections or arrays: " + fd.getFullName());
        }
        if (!this.messageContext.markField(fd.getNumber())) {
            throw new IllegalStateException("A field cannot be written twice : " + fd.getFullName());
        }
        if (this.ctx.getConfiguration().logOutOfSequenceWrites() && log.isEnabled(Logger.Level.WARN) && this.messageContext.getMaxSeenFieldNumber() > fd.getNumber()) {
            log.fieldWriteOutOfSequence(fd.getFullName());
        }
    }
}

