/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import org.infinispan.commons.CacheException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.logging.Log;

public abstract class AbstractTransport
implements Transport {
    protected GlobalConfiguration configuration;

    @Inject
    public void setConfiguration(GlobalConfiguration globalConfiguration) {
        this.configuration = globalConfiguration;
    }

    public Response checkResponse(Object responseObject, Address sender, boolean ignoreCacheNotFoundResponse) {
        Log log = this.getLog();
        if (responseObject == null) {
            return SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE;
        }
        if (responseObject instanceof Response) {
            Response response = (Response)responseObject;
            if (response instanceof ExceptionResponse) {
                ExceptionResponse exceptionResponse = (ExceptionResponse)response;
                Exception e = exceptionResponse.getException();
                if (e instanceof SuspectException) {
                    throw log.thirdPartySuspected(sender, (SuspectException)e);
                }
                if (e instanceof AvailabilityException || e instanceof OutdatedTopologyException) {
                    throw (CacheException)e;
                }
                throw log.remoteException(sender, e);
            }
            if (!ignoreCacheNotFoundResponse && response instanceof CacheNotFoundResponse) {
                throw new SuspectException("Cache not running on node " + sender, sender);
            }
            return response;
        }
        Class<?> responseClass = responseObject.getClass();
        log.tracef("Unexpected response object type from %s: %s", (Object)sender, (Object)responseClass);
        throw new CacheException(String.format("Unexpected response object type from %s: %s", sender, responseClass));
    }
}

