/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.VersionedRepeatableReadEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.TimeService;

public class WriteSkewHelper {
    public static void readVersionsFromResponse(Response r, CacheTransaction ct) {
        SuccessfulResponse sr;
        EntryVersionsMap uv;
        if (r != null && r.isSuccessful() && (uv = (EntryVersionsMap)(sr = (SuccessfulResponse)r).getResponseValue()) != null) {
            ct.setUpdatedEntryVersions(uv.merge(ct.getUpdatedEntryVersions()));
        }
    }

    public static EntryVersionsMap performWriteSkewCheckAndReturnNewVersions(VersionedPrepareCommand prepareCommand, DataContainer dataContainer, PersistenceManager persistenceManager, VersionGenerator versionGenerator, TxInvocationContext context, KeySpecificLogic ksl, TimeService timeService) {
        EntryVersionsMap uv = new EntryVersionsMap();
        if (prepareCommand.getVersionsSeen() == null) {
            return uv;
        }
        for (WriteCommand c : prepareCommand.getModifications()) {
            for (Object k : c.getAffectedKeys()) {
                CacheEntry cacheEntry;
                if (!ksl.performCheckOnKey(k) || !((cacheEntry = context.lookupEntry(k)) instanceof VersionedRepeatableReadEntry)) continue;
                VersionedRepeatableReadEntry entry = (VersionedRepeatableReadEntry)cacheEntry;
                if (entry.performWriteSkewCheck(dataContainer, persistenceManager, context, (EntryVersion)prepareCommand.getVersionsSeen().get(k), versionGenerator, timeService)) {
                    IncrementableEntryVersion oldVersion = (IncrementableEntryVersion)entry.getMetadata().version();
                    IncrementableEntryVersion newVersion = entry.isCreated() || oldVersion == null ? versionGenerator.generateNew() : versionGenerator.increment(oldVersion);
                    uv.put(k, newVersion);
                    continue;
                }
                throw new WriteSkewException("Write skew detected on key " + k + " for transaction " + context.getTransaction(), k);
            }
        }
        return uv;
    }

    public static EntryVersionsMap performTotalOrderWriteSkewCheckAndReturnNewVersions(VersionedPrepareCommand prepareCommand, DataContainer dataContainer, PersistenceManager persistenceManager, VersionGenerator versionGenerator, TxInvocationContext context, KeySpecificLogic ksl, TimeService timeService) {
        EntryVersionsMap uv = new EntryVersionsMap();
        for (WriteCommand c : prepareCommand.getModifications()) {
            for (Object k : c.getAffectedKeys()) {
                if (!ksl.performCheckOnKey(k)) continue;
                VersionedRepeatableReadEntry entry = (VersionedRepeatableReadEntry)context.lookupEntry(k);
                if (entry.performWriteSkewCheck(dataContainer, persistenceManager, context, (EntryVersion)prepareCommand.getVersionsSeen().get(k), versionGenerator, timeService)) {
                    uv.put(k, null);
                    continue;
                }
                throw new WriteSkewException("Write skew detected on key " + k + " for transaction " + context.getTransaction(), k);
            }
        }
        return uv;
    }

    public static interface KeySpecificLogic {
        public boolean performCheckOnKey(Object var1);
    }
}

