/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Set;
import javax.transaction.xa.Xid;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;

@Immutable
@Deprecated
public class SerializableXid
implements Xid {
    private final byte[] branchQualifier;
    private final byte[] globalTransactionId;
    private final int formatId;

    public SerializableXid(byte[] branchQualifier, byte[] globalTransactionId, int formantId) {
        this.branchQualifier = branchQualifier;
        this.globalTransactionId = globalTransactionId;
        this.formatId = formantId;
    }

    public SerializableXid(Xid xid) {
        this(xid.getBranchQualifier(), xid.getGlobalTransactionId(), xid.getFormatId());
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Xid)) {
            return false;
        }
        Xid xid = (Xid)o;
        if (this.formatId != xid.getFormatId()) {
            return false;
        }
        if (!Arrays.equals(this.branchQualifier, xid.getBranchQualifier())) {
            return false;
        }
        return Arrays.equals(this.globalTransactionId, xid.getGlobalTransactionId());
    }

    public int hashCode() {
        int result = this.branchQualifier != null ? Arrays.hashCode(this.branchQualifier) : 0;
        result = 31 * result + (this.globalTransactionId != null ? Arrays.hashCode(this.globalTransactionId) : 0);
        result = 31 * result + this.formatId;
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("< ");
        stringBuilder.append(this.formatId);
        stringBuilder.append(", ");
        stringBuilder.append(this.globalTransactionId.length);
        stringBuilder.append(", ");
        stringBuilder.append(this.branchQualifier.length);
        stringBuilder.append(", ");
        for (byte aGlobalTransactionId : this.globalTransactionId) {
            stringBuilder.append(aGlobalTransactionId);
        }
        stringBuilder.append(", ");
        for (byte aBranchQualifier : this.branchQualifier) {
            stringBuilder.append(aBranchQualifier);
        }
        stringBuilder.append(" >");
        return stringBuilder.toString();
    }

    public static class XidExternalizer
    extends AbstractExternalizer<SerializableXid> {
        @Override
        public void writeObject(ObjectOutput output, SerializableXid object) throws IOException {
            output.writeObject(object.getBranchQualifier());
            output.writeObject(object.getGlobalTransactionId());
            output.writeInt(object.getFormatId());
        }

        @Override
        public SerializableXid readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] bq = (byte[])input.readObject();
            byte[] gtId = (byte[])input.readObject();
            int type = input.readInt();
            return new SerializableXid(bq, gtId, type);
        }

        @Override
        public Set<Class<? extends SerializableXid>> getTypeClasses() {
            return Util.asSet(SerializableXid.class);
        }

        @Override
        public Integer getId() {
            return 32;
        }
    }
}

