/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Average
implements Streamable {
    protected double avg;
    protected long count;

    public <T extends Average> T add(long num) {
        if (num < 0L) {
            return (T)this;
        }
        if (Util.productGreaterThan(this.count, (long)Math.ceil(this.avg), Long.MAX_VALUE)) {
            this.clear();
        }
        double total = (double)this.count * this.avg;
        this.avg = (total + (double)num) / (double)(++this.count);
        return (T)this;
    }

    public <T extends Average> T merge(T other) {
        if (Util.productGreaterThan(this.count, (long)Math.ceil(this.avg), Long.MAX_VALUE) || Util.productGreaterThan(other.count(), (long)Math.ceil(other.average()), Long.MAX_VALUE)) {
            this.avg += other.average() / 2.0;
        } else {
            long total_count = this.count + other.count();
            this.avg = ((double)this.count * this.avg + (double)other.count() * other.average()) / (double)total_count;
            this.count = total_count / 2L;
        }
        return (T)this;
    }

    public double getAverage() {
        return this.avg;
    }

    public double average() {
        return this.avg;
    }

    public long getCount() {
        return this.count;
    }

    public long count() {
        return this.count;
    }

    public void clear() {
        this.avg = 0.0;
        this.count = 0L;
    }

    public String toString() {
        return String.valueOf(this.getAverage());
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeDouble(this.avg);
        Bits.writeLong(this.count, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.avg = in.readDouble();
        this.count = Bits.readLong(in);
    }
}

