/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.query;

import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.query.RemoteQueryBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.impl.BaseQueryFactory;
import org.infinispan.query.remote.client.MarshallerRegistration;
import org.infinispan.query.remote.client.QueryRequest;

public final class RemoteQueryFactory
extends BaseQueryFactory {
    private final RemoteCacheImpl<?, ?> cache;
    private final SerializationContext serializationContext;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RemoteQueryFactory(RemoteCacheImpl<?, ?> cache) {
        this.cache = cache;
        Marshaller marshaller = cache.getRemoteCacheManager().getMarshaller();
        if (marshaller instanceof ProtoStreamMarshaller) {
            this.serializationContext = ((ProtoStreamMarshaller)marshaller).getSerializationContext();
            try {
                if (this.serializationContext.canMarshall(QueryRequest.class)) return;
                MarshallerRegistration.registerMarshallers(this.serializationContext);
                return;
            }
            catch (Exception e) {
                throw new HotRodClientException("Failed to initialise the Protobuf serialization context", e);
            }
        } else {
            this.serializationContext = null;
        }
    }

    @Override
    public Query create(String queryString) {
        return new RemoteQuery(this, this.cache, this.serializationContext, queryString);
    }

    @Override
    public QueryBuilder from(Class<?> entityType) {
        String typeName = this.serializationContext != null ? this.serializationContext.getMarshaller(entityType).getTypeName() : entityType.getName();
        return new RemoteQueryBuilder(this, this.cache, this.serializationContext, typeName);
    }

    @Override
    public QueryBuilder from(String entityType) {
        if (this.serializationContext != null) {
            this.serializationContext.getMarshaller(entityType);
        }
        return new RemoteQueryBuilder(this, this.cache, this.serializationContext, entityType);
    }
}

