/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CommitCommand
extends AbstractTransactionBoundaryCommand {
    public static final byte COMMAND_ID = 14;
    private static final Log log = LogFactory.getLog(CommitCommand.class);

    private CommitCommand() {
        super(null);
    }

    public CommitCommand(ByteString cacheName, GlobalTransaction gtx) {
        super(cacheName);
        this.globalTx = gtx;
    }

    public CommitCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitCommitCommand((TxInvocationContext)ctx, this);
    }

    @Override
    protected Object invalidRemoteTxReturnValue() {
        TransactionTable.CompletedTransactionStatus txStatus = this.txTable.getCompletedTransactionStatus(this.globalTx);
        switch (txStatus) {
            case COMMITTED: {
                return null;
            }
            case ABORTED: {
                throw log.remoteTransactionAlreadyRolledBack(this.globalTx);
            }
            case EXPIRED: {
                throw log.remoteTransactionStatusMissing(this.globalTx);
            }
        }
        throw new IllegalStateException("Remote transaction not found: " + this.globalTx);
    }

    @Override
    public byte getCommandId() {
        return 14;
    }

    @Override
    public String toString() {
        return "CommitCommand {" + super.toString();
    }
}

