/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;

public class CompatModeEncoder
implements Encoder {
    protected final Marshaller marshaller;

    public CompatModeEncoder(Marshaller marshaller) {
        this.marshaller = marshaller == null ? new GenericJBossMarshaller() : marshaller;
    }

    @Override
    public Object toStorage(Object content) {
        if (content instanceof byte[]) {
            try {
                return this.unmarshall((byte[])content);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException(e);
            }
        }
        return content;
    }

    @Override
    public Object fromStorage(Object content) {
        try {
            return this.marshall(content);
        }
        catch (IOException | InterruptedException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public boolean isStorageFormatFilterable() {
        return true;
    }

    protected Object unmarshall(byte[] source) throws IOException, ClassNotFoundException {
        return this.marshaller.objectFromByteBuffer(source);
    }

    protected byte[] marshall(Object source) throws IOException, InterruptedException {
        return this.marshaller.objectToByteBuffer(source);
    }
}

