/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.commons.util.EvictionListener;
import org.infinispan.commons.util.PeekableMap;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntrySizeCalculator;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.PrimitiveEntrySizeCalculator;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionType;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.marshall.core.WrappedByteArraySizeCalculator;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.CoreImmutables;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.WithinThreadExecutor;

@ThreadSafe
public class DefaultDataContainer<K, V>
implements DataContainer<K, V> {
    private static final Log log = LogFactory.getLog(DefaultDataContainer.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentMap<K, InternalCacheEntry<K, V>> entries;
    private final Cache<K, InternalCacheEntry<K, V>> evictionCache;
    protected InternalEntryFactory entryFactory;
    private EvictionManager evictionManager;
    private PassivationManager passivator;
    private ActivationManager activator;
    private PersistenceManager pm;
    private TimeService timeService;
    private CacheNotifier cacheNotifier;
    private ExpirationManager<K, V> expirationManager;

    public DefaultDataContainer(int concurrencyLevel) {
        this.entries = CollectionFactory.makeConcurrentParallelMap(128, concurrencyLevel);
        this.evictionCache = null;
    }

    private static <K, V> Caffeine<K, V> caffeineBuilder() {
        return Caffeine.newBuilder();
    }

    protected DefaultDataContainer(int concurrencyLevel, long thresholdSize, EvictionType thresholdPolicy) {
        DefaultEvictionListener evictionListener = new DefaultEvictionListener();
        Caffeine<K, V> caffeine = DefaultDataContainer.caffeineBuilder();
        switch (thresholdPolicy) {
            case MEMORY: {
                CacheEntrySizeCalculator calc = new CacheEntrySizeCalculator(new WrappedByteArraySizeCalculator(new PrimitiveEntrySizeCalculator()));
                caffeine.weigher((k, v) -> (int)calc.calculateSize(k, v)).maximumWeight(thresholdSize);
                break;
            }
            case COUNT: {
                caffeine.maximumSize(thresholdSize);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Policy not supported: " + (Object)((Object)thresholdPolicy));
            }
        }
        this.evictionCache = this.applyListener(caffeine, evictionListener).build();
        this.entries = this.evictionCache.asMap();
    }

    private Caffeine<K, InternalCacheEntry<K, V>> applyListener(Caffeine<K, InternalCacheEntry<K, V>> caffeine, final DefaultEvictionListener listener) {
        return caffeine.executor(new WithinThreadExecutor()).removalListener((k, v, c) -> {
            switch (c) {
                case SIZE: {
                    listener.onEntryEviction(Collections.singletonMap(k, v));
                    break;
                }
                case EXPLICIT: {
                    listener.onEntryRemoved(new ImmortalCacheEntry(k, v));
                    break;
                }
                case REPLACED: {
                    listener.onEntryActivated(k);
                }
            }
        }).writer(new CacheWriter<K, InternalCacheEntry<K, V>>(){

            @Override
            public void write(K key, InternalCacheEntry<K, V> value) {
            }

            @Override
            public void delete(K key, InternalCacheEntry<K, V> value, RemovalCause cause) {
                if (cause == RemovalCause.SIZE) {
                    listener.onEntryChosenForEviction(new ImmortalCacheEntry(key, value));
                }
            }
        });
    }

    protected DefaultDataContainer(int concurrencyLevel, long thresholdSize, EntrySizeCalculator<? super K, ? super V> sizeCalculator) {
        DefaultEvictionListener evictionListener = new DefaultEvictionListener();
        CacheEntrySizeCalculator calc = new CacheEntrySizeCalculator(sizeCalculator);
        this.evictionCache = this.applyListener(Caffeine.newBuilder().weigher((k, v) -> (int)calc.calculateSize((Object)k, (Object)v)).maximumWeight(thresholdSize), evictionListener).build();
        this.entries = this.evictionCache.asMap();
    }

    @Inject
    public void initialize(EvictionManager evictionManager, PassivationManager passivator, InternalEntryFactory entryFactory, ActivationManager activator, PersistenceManager clm, TimeService timeService, CacheNotifier cacheNotifier, ExpirationManager<K, V> expirationManager) {
        this.evictionManager = evictionManager;
        this.passivator = passivator;
        this.entryFactory = entryFactory;
        this.activator = activator;
        this.pm = clm;
        this.timeService = timeService;
        this.cacheNotifier = cacheNotifier;
        this.expirationManager = expirationManager;
    }

    public static <K, V> DefaultDataContainer<K, V> boundedDataContainer(int concurrencyLevel, long maxEntries, EvictionType thresholdPolicy) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, maxEntries, thresholdPolicy);
    }

    public static <K, V> DefaultDataContainer<K, V> boundedDataContainer(int concurrencyLevel, long maxEntries, EntrySizeCalculator<? super K, ? super V> sizeCalculator) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, maxEntries, sizeCalculator);
    }

    public static <K, V> DefaultDataContainer<K, V> unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer<K, V>(concurrencyLevel);
    }

    @Override
    public InternalCacheEntry<K, V> peek(Object key) {
        if (this.entries instanceof PeekableMap) {
            return (InternalCacheEntry)((PeekableMap)((Object)this.entries)).peek(key);
        }
        return (InternalCacheEntry)this.entries.get(key);
    }

    @Override
    public InternalCacheEntry<K, V> get(Object k) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(k);
        if (e != null && e.canExpire()) {
            long currentTimeMillis = this.timeService.wallClockTime();
            if (e.isExpired(currentTimeMillis)) {
                this.expirationManager.handleInMemoryExpiration(e, currentTimeMillis);
                e = null;
            } else {
                e.touch(currentTimeMillis);
            }
        }
        return e;
    }

    @Override
    public void put(K k, V v, Metadata metadata) {
        boolean l1Entry = false;
        if (metadata instanceof L1Metadata) {
            metadata = ((L1Metadata)metadata).metadata();
            l1Entry = true;
        }
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(k);
        if (trace) {
            log.tracef("Creating new ICE for writing. Existing=%s, metadata=%s, new value=%s", (Object)e, (Object)metadata, (Object)Util.toStr(v));
        }
        InternalCacheEntry<K, V> copy = l1Entry ? this.entryFactory.createL1(k, v, metadata) : (e != null ? this.entryFactory.update(e, v, metadata) : this.entryFactory.create(k, v, metadata));
        if (trace) {
            log.tracef("Store %s in container", (Object)copy);
        }
        this.entries.compute(copy.getKey(), (? super K key, ? super V entry) -> {
            this.activator.onUpdate(key, entry == null);
            return copy;
        });
    }

    @Override
    public boolean containsKey(Object k) {
        long currentTimeMillis;
        InternalCacheEntry<K, V> ice = this.peek(k);
        if (ice != null && ice.canExpire() && ice.isExpired(currentTimeMillis = this.timeService.wallClockTime())) {
            this.expirationManager.handleInMemoryExpiration(ice, currentTimeMillis);
            ice = null;
        }
        return ice != null;
    }

    @Override
    public InternalCacheEntry<K, V> remove(Object k) {
        InternalCacheEntry[] reference = new InternalCacheEntry[1];
        this.entries.compute(k, (? super K key, ? super V entry) -> {
            this.activator.onRemove(key, entry == null);
            reference[0] = entry;
            return null;
        });
        InternalCacheEntry e = reference[0];
        if (trace) {
            log.tracef("Removed %s from container", (Object)e);
        }
        return e == null || e.canExpire() && e.isExpired(this.timeService.wallClockTime()) ? null : e;
    }

    private Policy.Eviction<K, InternalCacheEntry<K, V>> eviction() {
        Optional<Policy.Eviction<K, InternalCacheEntry<K, V>>> eviction;
        if (this.evictionCache != null && (eviction = this.evictionCache.policy().eviction()).isPresent()) {
            return eviction.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long capacity() {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        return evict.getMaximum();
    }

    @Override
    public void resize(long newSize) {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        evict.setMaximum(newSize);
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<InternalCacheEntry<K, V>> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            if (++size != Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    @Override
    public int sizeIncludingExpired() {
        return this.entries.size();
    }

    @Override
    public void clear() {
        log.tracef("Clearing data container", new Object[0]);
        this.entries.clear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public void evict(K key) {
        this.entries.computeIfPresent(key, (o, entry) -> {
            this.passivator.passivate((InternalCacheEntry)entry);
            return null;
        });
    }

    @Override
    public InternalCacheEntry<K, V> compute(K key, DataContainer.ComputeAction<K, V> action) {
        return this.entries.compute(key, (? super K k, ? super V oldEntry) -> {
            InternalCacheEntry newEntry = action.compute((K)k, (InternalCacheEntry<K, V>)oldEntry, this.entryFactory);
            if (newEntry == oldEntry) {
                return oldEntry;
            }
            if (newEntry == null) {
                this.activator.onRemove(k, false);
                return null;
            }
            this.activator.onUpdate(k, oldEntry == null);
            if (trace) {
                log.tracef("Store %s in container", (Object)newEntry);
            }
            return newEntry;
        });
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator() {
        return new EntryIterator(this.entries.values().iterator(), false);
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        return new EntryIterator(this.entries.values().iterator(), true);
    }

    @Override
    public void executeTask(KeyFilter<? super K> filter, BiConsumer<? super K, InternalCacheEntry<K, V>> action) throws InterruptedException {
        if (filter == null) {
            throw new IllegalArgumentException("No filter specified");
        }
        if (action == null) {
            throw new IllegalArgumentException("No action specified");
        }
        this.entries.forEach((? super K key, ? super V value) -> {
            if (filter.accept(key)) {
                action.accept((Object)key, (InternalCacheEntry)value);
            }
        });
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void executeTask(KeyValueFilter<? super K, ? super V> filter, BiConsumer<? super K, InternalCacheEntry<K, V>> action) throws InterruptedException {
        if (filter == null) {
            throw new IllegalArgumentException("No filter specified");
        }
        if (action == null) {
            throw new IllegalArgumentException("No action specified");
        }
        this.entries.forEach((? super K key, ? super V value) -> {
            if (filter.accept((Object)key, (Object)value.getValue(), value.getMetadata())) {
                action.accept((Object)key, (InternalCacheEntry)value);
            }
        });
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private static class ValueIterator<K, V>
    implements Iterator<V> {
        Iterator<InternalCacheEntry<K, V>> currentIterator;

        private ValueIterator(Iterator<InternalCacheEntry<K, V>> it) {
            this.currentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V next() {
            return this.currentIterator.next().getValue();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }

        @Override
        public Spliterator<V> spliterator() {
            return Spliterators.spliterator(this, 4096);
        }
    }

    private class EntrySet
    extends AbstractSet<InternalCacheEntry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            InternalCacheEntry ice = (InternalCacheEntry)DefaultDataContainer.this.entries.get(e.getKey());
            if (ice == null) {
                return false;
            }
            return ice.getValue().equals(e.getValue());
        }

        @Override
        public Iterator<InternalCacheEntry<K, V>> iterator() {
            return new ImmutableEntryIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }

        @Override
        public String toString() {
            return DefaultDataContainer.this.entries.toString();
        }

        @Override
        public Spliterator<InternalCacheEntry<K, V>> spliterator() {
            return Spliterators.spliterator(this, 4097);
        }
    }

    public class EntryIterator
    implements Iterator<InternalCacheEntry<K, V>> {
        private final Iterator<InternalCacheEntry<K, V>> it;
        private final boolean includeExpired;
        private InternalCacheEntry<K, V> next;

        EntryIterator(Iterator<InternalCacheEntry<K, V>> it, boolean includeExpired) {
            this.it = it;
            this.includeExpired = includeExpired;
        }

        private InternalCacheEntry<K, V> getNext() {
            boolean initializedTime = false;
            long now = 0L;
            while (this.it.hasNext()) {
                InternalCacheEntry entry = this.it.next();
                if (this.includeExpired || !entry.canExpire()) {
                    return entry;
                }
                if (!initializedTime) {
                    now = DefaultDataContainer.this.timeService.wallClockTime();
                    initializedTime = true;
                }
                if (entry.isExpired(now)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public InternalCacheEntry<K, V> next() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            InternalCacheEntry toReturn = this.next;
            this.next = null;
            return toReturn;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            return this.next != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ImmutableEntryIterator
    extends EntryIterator {
        ImmutableEntryIterator(Iterator<InternalCacheEntry<K, V>> it) {
            super(it, false);
        }

        @Override
        public InternalCacheEntry<K, V> next() {
            return CoreImmutables.immutableInternalCacheEntry(super.next());
        }
    }

    private final class DefaultEvictionListener
    implements EvictionListener<K, InternalCacheEntry<K, V>> {
        private DefaultEvictionListener() {
        }

        @Override
        public void onEntryEviction(Map<K, InternalCacheEntry<K, V>> evicted) {
            DefaultDataContainer.this.evictionManager.onEntryEviction(evicted);
        }

        @Override
        public void onEntryChosenForEviction(Map.Entry<K, InternalCacheEntry<K, V>> entry) {
            DefaultDataContainer.this.passivator.passivate(entry.getValue());
        }

        @Override
        public void onEntryActivated(Object key) {
            DefaultDataContainer.this.activator.onUpdate(key, true);
        }

        @Override
        public void onEntryRemoved(Map.Entry<K, InternalCacheEntry<K, V>> entry) {
        }
    }
}

