/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SyncConsistentHashFactory
implements ConsistentHashFactory<DefaultConsistentHash> {
    private static final Log log = LogFactory.getLog(SyncConsistentHashFactory.class);
    public static final float OWNED_SEGMENTS_ALLOWED_VARIATION = 1.1f;
    public static final float PRIMARY_SEGMENTS_ALLOWED_VARIATION = 1.05f;

    @Override
    public DefaultConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        this.checkCapacityFactors(members, capacityFactors);
        Builder builder = this.createBuilder(hashFunction, numOwners, numSegments, members, capacityFactors);
        builder.populateOwners(numSegments);
        builder.copyOwners();
        return new DefaultConsistentHash(hashFunction, numOwners, numSegments, members, capacityFactors, builder.segmentOwners);
    }

    @Override
    public DefaultConsistentHash fromPersistentState(ScopedPersistentState state) {
        String consistentHashClass = state.getProperty("consistentHash");
        if (!DefaultConsistentHash.class.getName().equals(consistentHashClass)) {
            throw log.persistentConsistentHashMismatch(this.getClass().getName(), consistentHashClass);
        }
        return new DefaultConsistentHash(state);
    }

    protected Builder createBuilder(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        return new Builder(hashFunction, numOwners, numSegments, members, capacityFactors);
    }

    protected void checkCapacityFactors(List<Address> members, Map<Address, Float> capacityFactors) {
        if (capacityFactors != null) {
            float totalCapacity = 0.0f;
            for (Address node : members) {
                Float capacityFactor = capacityFactors.get(node);
                if (capacityFactor == null || capacityFactor.floatValue() < 0.0f) {
                    throw new IllegalArgumentException("Invalid capacity factor for node " + node);
                }
                totalCapacity += capacityFactor.floatValue();
            }
            if (totalCapacity == 0.0f) {
                throw new IllegalArgumentException("There must be at least one node with a non-zero capacity factor");
            }
        }
    }

    @Override
    public DefaultConsistentHash updateMembers(DefaultConsistentHash baseCH, List<Address> newMembers, Map<Address, Float> actualCapacityFactors) {
        boolean sameCapacityFactors;
        this.checkCapacityFactors(newMembers, actualCapacityFactors);
        boolean bl = actualCapacityFactors == null ? baseCH.getCapacityFactors() == null : (sameCapacityFactors = actualCapacityFactors.equals(baseCH.getCapacityFactors()));
        if (newMembers.equals(baseCH.getMembers()) && sameCapacityFactors) {
            return baseCH;
        }
        int numSegments = baseCH.getNumSegments();
        int numOwners = baseCH.getNumOwners();
        HashSet<Address> leavers = new HashSet<Address>(baseCH.getMembers());
        leavers.removeAll(newMembers);
        ConsistentHash rebalancedCH = null;
        List[] newSegmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            ArrayList<Address> owners = new ArrayList<Address>(baseCH.locateOwnersForSegment(i));
            owners.removeAll(leavers);
            if (!owners.isEmpty()) {
                newSegmentOwners[i] = owners;
                continue;
            }
            if (rebalancedCH == null) {
                rebalancedCH = this.create(baseCH.getHashFunction(), numOwners, numSegments, (List)newMembers, (Map)actualCapacityFactors);
            }
            newSegmentOwners[i] = rebalancedCH.locateOwnersForSegment(i);
        }
        return new DefaultConsistentHash(baseCH.getHashFunction(), numOwners, numSegments, newMembers, actualCapacityFactors, newSegmentOwners);
    }

    @Override
    public DefaultConsistentHash rebalance(DefaultConsistentHash baseCH) {
        ConsistentHash rebalancedCH = this.create(baseCH.getHashFunction(), baseCH.getNumOwners(), baseCH.getNumSegments(), (List)baseCH.getMembers(), (Map)baseCH.getCapacityFactors());
        if (((DefaultConsistentHash)rebalancedCH).equals(baseCH)) {
            return baseCH;
        }
        return rebalancedCH;
    }

    @Override
    public DefaultConsistentHash union(DefaultConsistentHash ch1, DefaultConsistentHash ch2) {
        return ch1.union(ch2);
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass();
    }

    public int hashCode() {
        return -10007;
    }

    public static class Externalizer
    extends AbstractExternalizer<SyncConsistentHashFactory> {
        @Override
        public void writeObject(ObjectOutput output, SyncConsistentHashFactory chf) {
        }

        @Override
        public SyncConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new SyncConsistentHashFactory();
        }

        @Override
        public Integer getId() {
            return 52;
        }

        @Override
        public Set<Class<? extends SyncConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(SyncConsistentHashFactory.class);
        }
    }

    protected static class Builder {
        protected final Hash hashFunction;
        protected final int numOwners;
        protected final Map<Address, Float> capacityFactors;
        protected final int actualNumOwners;
        protected final int numSegments;
        protected final List<Address> sortedMembers;
        protected final int segmentSize;
        protected final List<Address>[] segmentOwners;
        protected final OwnershipStatistics stats;
        protected boolean ignoreMaxSegments;

        protected Builder(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
            this.hashFunction = hashFunction;
            this.numSegments = numSegments;
            this.numOwners = numOwners;
            this.actualNumOwners = Math.min(numOwners, members.size());
            this.sortedMembers = this.sort(members, capacityFactors);
            this.capacityFactors = this.populateCapacityFactors(capacityFactors, this.sortedMembers);
            this.segmentSize = Util.getSegmentSize(numSegments);
            this.segmentOwners = new List[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                this.segmentOwners[i] = new ArrayList<Address>(this.actualNumOwners);
            }
            this.stats = new OwnershipStatistics(members);
        }

        private Map<Address, Float> populateCapacityFactors(Map<Address, Float> capacityFactors, List<Address> sortedMembers) {
            if (capacityFactors != null) {
                return capacityFactors;
            }
            HashMap<Address, Float> realCapacityFactors = new HashMap<Address, Float>();
            for (Address member : sortedMembers) {
                realCapacityFactors.put(member, Float.valueOf(1.0f));
            }
            return realCapacityFactors;
        }

        protected void addOwnerNoCheck(int segment, Address owner) {
            this.segmentOwners[segment].add(owner);
            this.stats.incOwned(owner);
            if (this.segmentOwners[segment].size() == 1) {
                this.stats.incPrimaryOwned(owner);
            }
        }

        protected float computeTotalCapacity() {
            if (this.capacityFactors == null) {
                return this.sortedMembers.size();
            }
            float totalCapacity = 0.0f;
            for (Address member : this.sortedMembers) {
                Float capacityFactor = this.capacityFactors.get(member);
                totalCapacity += capacityFactor.floatValue();
            }
            return totalCapacity;
        }

        protected List<Address> sort(List<Address> members, final Map<Address, Float> capacityFactors) {
            ArrayList<Address> result = new ArrayList<Address>(members);
            Collections.sort(result, new Comparator<Address>(){

                @Override
                public int compare(Address o1, Address o2) {
                    int capacityComparison = capacityFactors != null ? ((Float)capacityFactors.get(o1)).compareTo((Float)capacityFactors.get(o2)) : 0;
                    return capacityComparison != 0 ? -capacityComparison : o1.compareTo(o2);
                }
            });
            return result;
        }

        protected void copyOwners() {
            this.ignoreMaxSegments = false;
            this.doCopyOwners();
            this.ignoreMaxSegments = true;
            this.doCopyOwners();
        }

        protected void doCopyOwners() {
            for (int segment = 0; segment < this.numSegments; ++segment) {
                List<Address> owners = this.segmentOwners[segment];
                int additionalOwnersSegment = this.nextSegment(segment);
                while (this.canAddOwners(owners) && additionalOwnersSegment != segment) {
                    List<Address> additionalOwners = this.segmentOwners[additionalOwnersSegment];
                    for (Address additionalOwner : additionalOwners) {
                        this.addBackupOwner(segment, additionalOwner);
                        if (this.canAddOwners(owners)) continue;
                        break;
                    }
                    additionalOwnersSegment = this.nextSegment(additionalOwnersSegment);
                }
            }
        }

        protected boolean canAddOwners(List<Address> owners) {
            return owners.size() < this.actualNumOwners;
        }

        protected int nextSegment(int segment) {
            if (segment == this.numSegments - 1) {
                return 0;
            }
            return segment + 1;
        }

        protected void populateOwners(int numSegments) {
            int virtualNode = 0;
            do {
                for (Address member : this.sortedMembers) {
                    int segment = this.computeSegment(member, virtualNode);
                    this.addPrimaryOwner(segment, member);
                }
                ++virtualNode;
            } while (this.stats.sumPrimaryOwned() < numSegments);
            virtualNode = 0;
            boolean membersWithZeroSegments = false;
            do {
                for (Address member : this.sortedMembers) {
                    if (this.stats.getOwned(member) > 0) continue;
                    membersWithZeroSegments = true;
                    int segment = this.computeSegment(member, virtualNode);
                    this.addBackupOwner(segment, member);
                }
                ++virtualNode;
            } while (membersWithZeroSegments && this.stats.sumOwned() < numSegments);
        }

        private int computeSegment(Address member, int virtualNode) {
            int virtualNodeHash = this.normalizedHash(this.hashFunction, member.hashCode());
            if (virtualNode != 0) {
                virtualNodeHash = this.normalizedHash(this.hashFunction, virtualNodeHash + virtualNode);
            }
            return virtualNodeHash / this.segmentSize;
        }

        protected double computeExpectedSegmentsForNode(Address node, int numCopies) {
            Float nodeCapacityFactor = this.capacityFactors.get(node);
            if (nodeCapacityFactor.floatValue() == 0.0f) {
                return 0.0;
            }
            double remainingCapacity = this.computeTotalCapacity();
            double remainingCopies = numCopies * this.numSegments;
            for (Address a : this.sortedMembers) {
                float capacityFactor = this.capacityFactors.get(a).floatValue();
                double nodeSegments = (double)capacityFactor / remainingCapacity * remainingCopies;
                if (nodeSegments > (double)this.numSegments) {
                    nodeSegments = this.numSegments;
                    remainingCapacity -= (double)capacityFactor;
                    remainingCopies -= nodeSegments;
                    if (!node.equals(a)) continue;
                    return nodeSegments;
                }
                if (!node.equals(a)) {
                    nodeSegments = (double)nodeCapacityFactor.floatValue() / remainingCapacity * remainingCopies;
                }
                return Math.max(nodeSegments, 1.0);
            }
            throw new IllegalStateException("The nodes collection does not include " + node);
        }

        protected boolean addPrimaryOwner(int segment, Address candidate) {
            List<Address> owners = this.segmentOwners[segment];
            if (owners.isEmpty()) {
                double expectedSegments = this.computeExpectedSegmentsForNode(candidate, 1);
                long maxSegments = Math.round(Math.ceil(expectedSegments) * (double)1.05f);
                if ((long)this.stats.getPrimaryOwned(candidate) < maxSegments) {
                    this.addOwnerNoCheck(segment, candidate);
                    return true;
                }
            }
            return false;
        }

        protected boolean addBackupOwner(int segment, Address candidate) {
            List<Address> owners = this.segmentOwners[segment];
            if (owners.size() < this.actualNumOwners && !owners.contains(candidate)) {
                if (!this.ignoreMaxSegments) {
                    double expectedSegments = this.computeExpectedSegmentsForNode(candidate, this.actualNumOwners);
                    long maxSegments = Math.round(Math.ceil(expectedSegments) * (double)1.1f);
                    if ((long)this.stats.getOwned(candidate) < maxSegments) {
                        this.addOwnerNoCheck(segment, candidate);
                        return true;
                    }
                } else if (!this.capacityFactors.get(candidate).equals(Float.valueOf(0.0f))) {
                    this.addOwnerNoCheck(segment, candidate);
                    return true;
                }
            }
            return false;
        }

        protected int normalizedHash(Hash hashFunction, int hashcode) {
            return hashFunction.hash(hashcode) & Integer.MAX_VALUE;
        }
    }
}

