/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.Codec10;
import org.infinispan.client.hotrod.impl.protocol.Codec11;
import org.infinispan.client.hotrod.impl.protocol.Codec12;
import org.infinispan.client.hotrod.impl.protocol.Codec13;
import org.infinispan.client.hotrod.impl.protocol.Codec20;
import org.infinispan.client.hotrod.impl.protocol.Codec21;
import org.infinispan.client.hotrod.impl.protocol.Codec22;
import org.infinispan.client.hotrod.impl.protocol.Codec23;
import org.infinispan.client.hotrod.impl.protocol.Codec24;
import org.infinispan.client.hotrod.impl.protocol.Codec25;
import org.infinispan.client.hotrod.impl.protocol.Codec26;

public class CodecFactory {
    private static final Map<ProtocolVersion, Codec> codecMap;
    private static final Codec CODEC_10;
    private static final Codec CODEC_11;
    private static final Codec CODEC_12;
    private static final Codec CODEC_13;
    private static final Codec CODEC_20;
    private static final Codec CODEC_21;
    private static final Codec CODEC_22;
    private static final Codec CODEC_23;
    private static final Codec CODEC_24;
    private static final Codec CODEC_25;
    private static final Codec CODEC_26;

    public static boolean isVersionDefined(String version) {
        ProtocolVersion protocolVersion = ProtocolVersion.parseVersion(version);
        if (protocolVersion == null) {
            return false;
        }
        return codecMap.containsKey((Object)protocolVersion);
    }

    public static Codec getCodec(ProtocolVersion version) {
        if (codecMap.containsKey((Object)version)) {
            return codecMap.get((Object)version);
        }
        throw new IllegalArgumentException(String.format("Invalid Hot Rod protocol version '%s'", new Object[]{version}));
    }

    static {
        CODEC_10 = new Codec10();
        CODEC_11 = new Codec11();
        CODEC_12 = new Codec12();
        CODEC_13 = new Codec13();
        CODEC_20 = new Codec20();
        CODEC_21 = new Codec21();
        CODEC_22 = new Codec22();
        CODEC_23 = new Codec23();
        CODEC_24 = new Codec24();
        CODEC_25 = new Codec25();
        CODEC_26 = new Codec26();
        codecMap = new HashMap<ProtocolVersion, Codec>();
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_10, CODEC_10);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_11, CODEC_11);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_12, CODEC_12);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_13, CODEC_13);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_20, CODEC_20);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_21, CODEC_21);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_22, CODEC_22);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_23, CODEC_23);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_24, CODEC_24);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_25, CODEC_25);
        codecMap.put(ProtocolVersion.PROTOCOL_VERSION_26, CODEC_26);
    }
}

